/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.filter.Filter;

public class Equiconditions {
    @Nonnull
    private final Map<String, Set<Expr>> equiconditions;

    public Equiconditions(Map<String, Set<Expr>> equiconditions) {
        this.equiconditions = equiconditions;
    }

    public boolean doesFilterSupportDirectJoinFilterRewrite(Filter filterClause) {
        Set<String> requiredColumns;
        if (filterClause.supportsRequiredColumnRewrite() && (requiredColumns = filterClause.getRequiredColumns()).size() == 1) {
            String reqColumn = requiredColumns.iterator().next();
            return this.equiconditions.containsKey(reqColumn);
        }
        return false;
    }

    @Nullable
    public Set<Expr> getLhsExprs(String rhsColumn) {
        return this.equiconditions.get(rhsColumn);
    }
}

