/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.base.Predicate;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;

public class PossiblyNullDimensionSelector
extends AbstractDimensionSelector
implements IdLookup {
    private final DimensionSelector baseSelector;
    private final BooleanSupplier beNull;
    private final NullAdjustedIndexedInts nullAdjustedRow;
    private final int nullAdjustment;

    public PossiblyNullDimensionSelector(DimensionSelector baseSelector, BooleanSupplier beNull) {
        this.baseSelector = baseSelector;
        this.beNull = beNull;
        this.nullAdjustment = baseSelector.nameLookupPossibleInAdvance() && (baseSelector.getValueCardinality() == 0 || baseSelector.getValueCardinality() > 0 && baseSelector.lookupName(0) != null) ? 1 : 0;
        this.nullAdjustedRow = new NullAdjustedIndexedInts(this.nullAdjustment);
    }

    @Override
    @Nonnull
    public IndexedInts getRow() {
        if (this.beNull.getAsBoolean()) {
            return ZeroIndexedInts.instance();
        }
        this.nullAdjustedRow.set(this.baseSelector.getRow());
        return this.nullAdjustedRow;
    }

    @Override
    @Nonnull
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    @Nonnull
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    @Override
    public int getValueCardinality() {
        return this.baseSelector.getValueCardinality() + this.nullAdjustment;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        int cardinality = this.getValueCardinality();
        if (cardinality == -1) {
            if (this.beNull.getAsBoolean()) {
                assert (id == 0);
                return null;
            }
            return this.baseSelector.lookupName(id - this.nullAdjustment);
        }
        assert (cardinality > 0);
        if (id == 0) {
            return null;
        }
        return this.baseSelector.lookupName(id - this.nullAdjustment);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return this.baseSelector.nameLookupPossibleInAdvance();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.baseSelector.idLookup() != null ? this : null;
    }

    @Override
    public int lookupId(@Nullable String name) {
        if (name == null) {
            return 0;
        }
        IdLookup idLookup = this.baseSelector.idLookup();
        assert (idLookup != null);
        return idLookup.lookupId(name) + this.nullAdjustment;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("beNull", this.beNull);
        this.baseSelector.inspectRuntimeShape(inspector);
    }

    @Override
    public Class<?> classOfObject() {
        return this.baseSelector.classOfObject();
    }

    private static class NullAdjustedIndexedInts
    implements IndexedInts {
        private final int nullAdjustment;
        private IndexedInts ints = null;

        public NullAdjustedIndexedInts(int nullAdjustment) {
            this.nullAdjustment = nullAdjustment;
        }

        public void set(IndexedInts ints) {
            this.ints = ints;
        }

        @Override
        public int size() {
            return this.ints.size();
        }

        @Override
        public int get(int index) {
            return this.ints.get(index) + this.nullAdjustment;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("ints", this.ints);
        }
    }
}

