/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.segment.writeout.WriteOutBytes;

public interface ObjectStrategy<T>
extends Comparator<T> {
    public Class<? extends T> getClazz();

    @Nullable
    public T fromByteBuffer(ByteBuffer var1, int var2);

    @Nullable
    public byte[] toBytes(@Nullable T var1);

    default public boolean canCompare() {
        return true;
    }

    default public T fromByteBufferWithSize(ByteBuffer buffer) {
        int size = buffer.getInt();
        ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
        bufferToUse.limit(bufferToUse.position() + size);
        buffer.position(bufferToUse.limit());
        return this.fromByteBuffer(bufferToUse, size);
    }

    default public void writeTo(T val, WriteOutBytes out) throws IOException {
        byte[] bytes = this.toBytes(val);
        if (bytes != null) {
            out.write(bytes);
        }
    }
}

