/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;

public class TimeAndDimsPointer
implements Comparable<TimeAndDimsPointer> {
    final ColumnValueSelector timestampSelector;
    final ColumnValueSelector[] dimensionSelectors;
    private final List<DimensionHandler> dimensionHandlers;
    private final Comparator<ColumnValueSelector>[] dimensionSelectorComparators;
    final ColumnValueSelector[] metricSelectors;
    private final List<String> metricNames;

    TimeAndDimsPointer(ColumnValueSelector timestampSelector, ColumnValueSelector[] dimensionSelectors, List<DimensionHandler> dimensionHandlers, ColumnValueSelector[] metricSelectors, List<String> metricNames) {
        this.timestampSelector = timestampSelector;
        Preconditions.checkArgument((dimensionSelectors.length == dimensionHandlers.size() ? 1 : 0) != 0);
        this.dimensionSelectors = dimensionSelectors;
        this.dimensionHandlers = dimensionHandlers;
        this.dimensionSelectorComparators = (Comparator[])dimensionHandlers.stream().map(DimensionHandler::getEncodedValueSelectorComparator).toArray(Comparator[]::new);
        Preconditions.checkArgument((metricSelectors.length == metricNames.size() ? 1 : 0) != 0);
        this.metricSelectors = metricSelectors;
        this.metricNames = metricNames;
    }

    public long getTimestamp() {
        return this.timestampSelector.getLong();
    }

    ColumnValueSelector getDimensionSelector(int dimIndex) {
        return this.dimensionSelectors[dimIndex];
    }

    int getNumDimensions() {
        return this.dimensionSelectors.length;
    }

    List<DimensionHandler> getDimensionHandlers() {
        return this.dimensionHandlers;
    }

    ColumnValueSelector getMetricSelector(int metricIndex) {
        return this.metricSelectors[metricIndex];
    }

    public int getNumMetrics() {
        return this.metricSelectors.length;
    }

    List<String> getMetricNames() {
        return this.metricNames;
    }

    TimeAndDimsPointer withDimensionSelectors(ColumnValueSelector[] newDimensionSelectors) {
        return new TimeAndDimsPointer(this.timestampSelector, newDimensionSelectors, this.dimensionHandlers, this.metricSelectors, this.getMetricNames());
    }

    @Override
    public int compareTo(@Nonnull TimeAndDimsPointer rhs) {
        long rhsTimestamp;
        long timestamp = this.getTimestamp();
        int timestampDiff = Long.compare(timestamp, rhsTimestamp = rhs.getTimestamp());
        if (timestampDiff != 0) {
            return timestampDiff;
        }
        for (int dimIndex = 0; dimIndex < this.dimensionSelectors.length; ++dimIndex) {
            int dimDiff = this.dimensionSelectorComparators[dimIndex].compare(this.dimensionSelectors[dimIndex], rhs.dimensionSelectors[dimIndex]);
            if (dimDiff == 0) continue;
            return dimDiff;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Should not compare TimeAndDimsPointers using equals(), only compareTo()");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Should not compute hashCode() on TimeAndDimsPointer");
    }

    List<Object> getDimensionValuesForDebug() {
        return Arrays.stream(this.dimensionSelectors).map(BaseObjectColumnValueSelector::getObject).collect(Collectors.toList());
    }

    public String toString() {
        return "TimeAndDimsPointer{timestamp=" + DateTimes.utc((long)this.getTimestamp()) + ", dimensions=" + this.getDimensionNamesToValuesForDebug() + ", metrics=" + this.getMetricNamesToValuesForDebug() + '}';
    }

    Map<String, Object> getDimensionNamesToValuesForDebug() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.getNumDimensions(); ++i) {
            Object value = this.dimensionSelectors[i].getObject();
            result.put(this.dimensionHandlers.get(i).getDimensionName(), value);
        }
        return result;
    }

    Map<String, Object> getMetricNamesToValuesForDebug() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < this.getNumMetrics(); ++i) {
            result.put(this.metricNames.get(i), this.metricSelectors[i].getObject());
        }
        return result;
    }
}

