/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountingCloseableObject;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class ReferenceCountingSegment
extends ReferenceCountingCloseableObject<Segment>
implements SegmentReference,
Overshadowable<ReferenceCountingSegment> {
    private final short startRootPartitionId;
    private final short endRootPartitionId;
    private final short minorVersion;
    private final short atomicUpdateGroupSize;

    public static ReferenceCountingSegment wrapRootGenerationSegment(Segment baseSegment) {
        return new ReferenceCountingSegment((Segment)Preconditions.checkNotNull((Object)baseSegment, (Object)"baseSegment"), baseSegment.getId().getPartitionNum(), baseSegment.getId().getPartitionNum() + 1, 0, 1);
    }

    public static ReferenceCountingSegment wrapSegment(Segment baseSegment, ShardSpec shardSpec) {
        return new ReferenceCountingSegment(baseSegment, shardSpec.getStartRootPartitionId(), shardSpec.getEndRootPartitionId(), shardSpec.getMinorVersion(), shardSpec.getAtomicUpdateGroupSize());
    }

    protected ReferenceCountingSegment(Segment baseSegment, int startRootPartitionId, int endRootPartitionId, short minorVersion, short atomicUpdateGroupSize) {
        super(baseSegment);
        this.startRootPartitionId = (short)startRootPartitionId;
        this.endRootPartitionId = (short)endRootPartitionId;
        this.minorVersion = minorVersion;
        this.atomicUpdateGroupSize = atomicUpdateGroupSize;
    }

    @Nullable
    public Segment getBaseSegment() {
        return !this.isClosed() ? (Segment)this.baseObject : null;
    }

    @Override
    @Nullable
    public SegmentId getId() {
        return !this.isClosed() ? ((Segment)this.baseObject).getId() : null;
    }

    @Override
    @Nullable
    public Interval getDataInterval() {
        return !this.isClosed() ? ((Segment)this.baseObject).getDataInterval() : null;
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return !this.isClosed() ? ((Segment)this.baseObject).asQueryableIndex() : null;
    }

    @Override
    @Nullable
    public StorageAdapter asStorageAdapter() {
        return !this.isClosed() ? ((Segment)this.baseObject).asStorageAdapter() : null;
    }

    public boolean overshadows(ReferenceCountingSegment other) {
        if (((Segment)this.baseObject).getId().getDataSource().equals(((Segment)other.baseObject).getId().getDataSource()) && ((Segment)this.baseObject).getId().getInterval().overlaps((ReadableInterval)((Segment)other.baseObject).getId().getInterval())) {
            int majorVersionCompare = ((Segment)this.baseObject).getId().getVersion().compareTo(((Segment)other.baseObject).getId().getVersion());
            if (majorVersionCompare > 0) {
                return true;
            }
            if (majorVersionCompare == 0) {
                return this.includeRootPartitions(other) && this.getMinorVersion() > other.getMinorVersion();
            }
        }
        return false;
    }

    private boolean includeRootPartitions(ReferenceCountingSegment other) {
        return this.startRootPartitionId <= other.startRootPartitionId && this.endRootPartitionId >= other.endRootPartitionId;
    }

    public int getStartRootPartitionId() {
        return this.startRootPartitionId;
    }

    public int getEndRootPartitionId() {
        return this.endRootPartitionId;
    }

    public String getVersion() {
        return ((Segment)this.baseObject).getId().getVersion();
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getAtomicUpdateGroupSize() {
        return this.atomicUpdateGroupSize;
    }

    @Override
    public Optional<Closeable> acquireReferences() {
        return this.incrementReferenceAndDecrementOnceCloseable();
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (this.isClosed()) {
            return null;
        }
        return ((Segment)this.baseObject).as(clazz);
    }
}

