/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.nested.GlobalDictionarySortedCollector;
import org.apache.druid.segment.nested.GlobalDimensionDictionary;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedLiteralTypeInfo;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;

public class NestedDataColumnIndexer
implements DimensionIndexer<StructuredData, StructuredData, StructuredData> {
    protected volatile boolean hasNulls = false;
    protected SortedMap<String, LiteralFieldIndexer> fieldIndexers = new TreeMap<String, LiteralFieldIndexer>();
    protected final GlobalDimensionDictionary globalDictionary = new GlobalDimensionDictionary();
    int estimatedFieldKeySize = 0;
    protected final StructuredDataProcessor indexerProcessor = new StructuredDataProcessor(){

        @Override
        public int processLiteralField(String fieldName, Object fieldValue) {
            LiteralFieldIndexer fieldIndexer = (LiteralFieldIndexer)NestedDataColumnIndexer.this.fieldIndexers.get(fieldName);
            if (fieldIndexer == null) {
                NestedDataColumnIndexer.this.estimatedFieldKeySize += StructuredDataProcessor.estimateStringSize(fieldName);
                fieldIndexer = new LiteralFieldIndexer(NestedDataColumnIndexer.this.globalDictionary);
                NestedDataColumnIndexer.this.fieldIndexers.put(fieldName, fieldIndexer);
            }
            return fieldIndexer.processValue(fieldValue);
        }
    };

    @Override
    public EncodedKeyComponent<StructuredData> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        StructuredData data;
        long oldDictSizeInBytes = this.globalDictionary.sizeInBytes();
        int oldFieldKeySize = this.estimatedFieldKeySize;
        if (dimValues == null) {
            this.hasNulls = true;
            data = null;
        } else {
            data = dimValues instanceof StructuredData ? (StructuredData)dimValues : new StructuredData(dimValues);
        }
        StructuredDataProcessor.ProcessResults info = this.indexerProcessor.processFields(data == null ? null : data.getValue());
        long effectiveSizeBytes = info.getEstimatedSize();
        effectiveSizeBytes += this.globalDictionary.sizeInBytes() - oldDictSizeInBytes;
        return new EncodedKeyComponent<StructuredData>(data, effectiveSizeBytes += (long)(this.estimatedFieldKeySize - oldFieldKeySize));
    }

    @Override
    public void setSparseIndexed() {
        this.hasNulls = true;
    }

    @Override
    public StructuredData getUnsortedEncodedValueFromSorted(StructuredData sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<StructuredData> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public StructuredData getMinValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public StructuredData getMaxValue() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getCardinality() {
        return this.globalDictionary.getCardinality();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        return new ObjectColumnSelector<StructuredData>(){

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            @Nullable
            public StructuredData getObject() {
                return (StructuredData)currEntry.get().getDims()[dimIndex];
            }

            @Override
            public Class<StructuredData> classOfObject() {
                return StructuredData.class;
            }
        };
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        return ColumnCapabilitiesImpl.createDefault().setType(NestedDataComplexTypeSerde.TYPE).setHasNulls(this.hasNulls);
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return StructuredData.COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable StructuredData lhs, @Nullable StructuredData rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable StructuredData key) {
        return Objects.hash(key);
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(StructuredData key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(StructuredData key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void mergeFields(SortedMap<String, NestedLiteralTypeInfo.MutableTypeSet> mergedFields) {
        for (Map.Entry<String, LiteralFieldIndexer> entry : this.fieldIndexers.entrySet()) {
            if (entry.getValue().getTypes().isEmpty()) continue;
            mergedFields.put(entry.getKey(), entry.getValue().getTypes());
        }
    }

    public GlobalDictionarySortedCollector getSortedCollector() {
        return this.globalDictionary.getSortedCollector();
    }

    static class LiteralFieldIndexer {
        private final GlobalDimensionDictionary globalDimensionDictionary;
        private final NestedLiteralTypeInfo.MutableTypeSet typeSet;

        LiteralFieldIndexer(GlobalDimensionDictionary globalDimensionDictionary) {
            this.globalDimensionDictionary = globalDimensionDictionary;
            this.typeSet = new NestedLiteralTypeInfo.MutableTypeSet();
        }

        private int processValue(@Nullable Object value) {
            if (value != null) {
                ExprEval eval = ExprEval.bestEffortOf((Object)value);
                ColumnType columnType = ExpressionType.toColumnType((ExpressionType)eval.type());
                switch ((ValueType)columnType.getType()) {
                    case LONG: {
                        this.globalDimensionDictionary.addLongValue(eval.asLong());
                        this.typeSet.add(ColumnType.LONG);
                        return StructuredDataProcessor.getLongObjectEstimateSize();
                    }
                    case DOUBLE: {
                        this.globalDimensionDictionary.addDoubleValue(eval.asDouble());
                        this.typeSet.add(ColumnType.DOUBLE);
                        return StructuredDataProcessor.getDoubleObjectEstimateSize();
                    }
                }
                String asString = eval.asString();
                this.globalDimensionDictionary.addStringValue(asString);
                this.typeSet.add(ColumnType.STRING);
                return StructuredDataProcessor.estimateStringSize(asString);
            }
            return 0;
        }

        public NestedLiteralTypeInfo.MutableTypeSet getTypes() {
            return this.typeSet;
        }
    }
}

