/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.loading.SegmentizerFactory;

public class IndexSpec {
    public static final CompressionStrategy DEFAULT_METRIC_COMPRESSION = CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionStrategy DEFAULT_DIMENSION_COMPRESSION = CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY;
    public static final CompressionFactory.LongEncodingStrategy DEFAULT_LONG_ENCODING = CompressionFactory.DEFAULT_LONG_ENCODING_STRATEGY;
    private static final Set<CompressionStrategy> METRIC_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressionStrategy.values()));
    private static final Set<CompressionStrategy> DIMENSION_COMPRESSION = Sets.newHashSet(Arrays.asList(CompressionStrategy.noNoneValues()));
    private static final Set<CompressionFactory.LongEncodingStrategy> LONG_ENCODING_NAMES = Sets.newHashSet(Arrays.asList(CompressionFactory.LongEncodingStrategy.values()));
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final CompressionStrategy dimensionCompression;
    private final CompressionStrategy metricCompression;
    private final CompressionFactory.LongEncodingStrategy longEncoding;
    @Nullable
    private final CompressionStrategy jsonCompression;
    @Nullable
    private final SegmentizerFactory segmentLoader;

    public IndexSpec() {
        this(null, null, null, null, null, null);
    }

    @VisibleForTesting
    public IndexSpec(@Nullable BitmapSerdeFactory bitmapSerdeFactory, @Nullable CompressionStrategy dimensionCompression, @Nullable CompressionStrategy metricCompression, @Nullable CompressionFactory.LongEncodingStrategy longEncoding) {
        this(bitmapSerdeFactory, dimensionCompression, metricCompression, longEncoding, null, null);
    }

    @VisibleForTesting
    public IndexSpec(@Nullable BitmapSerdeFactory bitmapSerdeFactory, @Nullable CompressionStrategy dimensionCompression, @Nullable CompressionStrategy metricCompression, @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @Nullable SegmentizerFactory segmentLoader) {
        this(bitmapSerdeFactory, dimensionCompression, metricCompression, longEncoding, null, segmentLoader);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") @Nullable CompressionStrategy dimensionCompression, @JsonProperty(value="metricCompression") @Nullable CompressionStrategy metricCompression, @JsonProperty(value="longEncoding") @Nullable CompressionFactory.LongEncodingStrategy longEncoding, @JsonProperty(value="jsonCompression") @Nullable CompressionStrategy jsonCompression, @JsonProperty(value="segmentLoader") @Nullable SegmentizerFactory segmentLoader) {
        Preconditions.checkArgument((dimensionCompression == null || DIMENSION_COMPRESSION.contains((Object)dimensionCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{dimensionCompression});
        Preconditions.checkArgument((metricCompression == null || METRIC_COMPRESSION.contains((Object)metricCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{metricCompression});
        Preconditions.checkArgument((longEncoding == null || LONG_ENCODING_NAMES.contains((Object)longEncoding) ? 1 : 0) != 0, (String)"Unknown long encoding type[%s]", (Object[])new Object[]{longEncoding});
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.DefaultBitmapSerdeFactory();
        this.dimensionCompression = dimensionCompression == null ? DEFAULT_DIMENSION_COMPRESSION : dimensionCompression;
        this.metricCompression = metricCompression == null ? DEFAULT_METRIC_COMPRESSION : metricCompression;
        this.longEncoding = longEncoding == null ? DEFAULT_LONG_ENCODING : longEncoding;
        this.jsonCompression = jsonCompression;
        this.segmentLoader = segmentLoader;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public CompressionStrategy getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty
    public CompressionStrategy getMetricCompression() {
        return this.metricCompression;
    }

    @JsonProperty
    public CompressionFactory.LongEncodingStrategy getLongEncoding() {
        return this.longEncoding;
    }

    @JsonProperty
    @Nullable
    public SegmentizerFactory getSegmentLoader() {
        return this.segmentLoader;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public CompressionStrategy getJsonCompression() {
        return this.jsonCompression;
    }

    public Map<String, Object> asMap(ObjectMapper objectMapper) {
        return (Map)objectMapper.convertValue((Object)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        return Objects.equals(this.bitmapSerdeFactory, indexSpec.bitmapSerdeFactory) && this.dimensionCompression == indexSpec.dimensionCompression && this.metricCompression == indexSpec.metricCompression && this.longEncoding == indexSpec.longEncoding && Objects.equals((Object)this.jsonCompression, (Object)indexSpec.jsonCompression) && Objects.equals(this.segmentLoader, indexSpec.segmentLoader);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bitmapSerdeFactory, this.dimensionCompression, this.metricCompression, this.longEncoding, this.jsonCompression, this.segmentLoader});
    }

    public String toString() {
        return "IndexSpec{bitmapSerdeFactory=" + this.bitmapSerdeFactory + ", dimensionCompression=" + (Object)((Object)this.dimensionCompression) + ", metricCompression=" + (Object)((Object)this.metricCompression) + ", longEncoding=" + (Object)((Object)this.longEncoding) + ", jsonCompression=" + (Object)((Object)this.jsonCompression) + ", segmentLoader=" + this.segmentLoader + '}';
    }
}

