/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionDictionary;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.SortedDimensionDictionary;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

public abstract class DictionaryEncodedColumnIndexer<KeyType, ActualType extends Comparable<ActualType>>
implements DimensionIndexer<Integer, KeyType, ActualType> {
    protected final DimensionDictionary<ActualType> dimLookup;
    protected volatile boolean isSparse = false;
    @Nullable
    protected SortedDimensionDictionary<ActualType> sortedLookup;

    public DictionaryEncodedColumnIndexer(@NotNull DimensionDictionary<ActualType> dimLookup) {
        this.dimLookup = (DimensionDictionary)Preconditions.checkNotNull(dimLookup);
    }

    @Override
    public void setSparseIndexed() {
        this.isSparse = true;
    }

    public int getSortedEncodedValueFromUnsorted(Integer unsortedIntermediateValue) {
        return this.sortedLookup().getSortedIdFromUnsortedId(unsortedIntermediateValue);
    }

    @Override
    public Integer getUnsortedEncodedValueFromSorted(Integer sortedIntermediateValue) {
        return this.sortedLookup().getUnsortedIdFromSortedId(sortedIntermediateValue);
    }

    @Override
    public CloseableIndexed<ActualType> getSortedIndexedValues() {
        return new CloseableIndexed<ActualType>(){

            @Override
            public int size() {
                return DictionaryEncodedColumnIndexer.this.getCardinality();
            }

            @Override
            public ActualType get(int index) {
                return DictionaryEncodedColumnIndexer.this.getActualValue(index, true);
            }

            @Override
            public int indexOf(ActualType value) {
                int id = DictionaryEncodedColumnIndexer.this.getEncodedValue(value, false);
                return id < 0 ? -1 : DictionaryEncodedColumnIndexer.this.getSortedEncodedValueFromUnsorted(id);
            }

            @Override
            public Iterator<ActualType> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public ActualType getMinValue() {
        return this.dimLookup.getMinValue();
    }

    @Override
    public ActualType getMaxValue() {
        return this.dimLookup.getMaxValue();
    }

    @Override
    public int getCardinality() {
        return this.dimLookup.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return this.makeDimensionSelector(desc.getHandler().getDimensionSpec(), currEntry, desc);
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        final DimensionSelector dimSelectorWithUnsortedValues = (DimensionSelector)selectorWithUnsortedValues;
        class SortedDimensionSelector
        implements DimensionSelector,
        IndexedInts {
            SortedDimensionSelector() {
            }

            @Override
            public int size() {
                return dimSelectorWithUnsortedValues.getRow().size();
            }

            @Override
            public int get(int index) {
                return DictionaryEncodedColumnIndexer.this.sortedLookup().getSortedIdFromUnsortedId(dimSelectorWithUnsortedValues.getRow().get(index));
            }

            @Override
            public IndexedInts getRow() {
                return this;
            }

            @Override
            public ValueMatcher makeValueMatcher(@Nullable String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getValueCardinality() {
                return dimSelectorWithUnsortedValues.getValueCardinality();
            }

            @Override
            @Nullable
            public String lookupName(int id) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("dimSelectorWithUnsortedValues", dimSelectorWithUnsortedValues);
            }

            @Override
            @Nullable
            public Object getObject() {
                return dimSelectorWithUnsortedValues.getObject();
            }

            @Override
            public Class classOfObject() {
                return dimSelectorWithUnsortedValues.classOfObject();
            }
        }
        return new SortedDimensionSelector();
    }

    protected boolean dictionaryEncodesAllValues() {
        return !this.isSparse || this.dimLookup.getIdForNull() != -1;
    }

    protected SortedDimensionDictionary<ActualType> sortedLookup() {
        return this.sortedLookup == null ? (this.sortedLookup = this.dimLookup.sort()) : this.sortedLookup;
    }

    @Nullable
    protected ActualType getActualValue(int intermediateValue, boolean idSorted) {
        if (idSorted) {
            return this.sortedLookup().getValueFromSortedId(intermediateValue);
        }
        return this.dimLookup.getValue(intermediateValue);
    }

    protected int getEncodedValue(@Nullable ActualType fullValue, boolean idSorted) {
        int unsortedId = this.dimLookup.getId(fullValue);
        if (idSorted) {
            return this.sortedLookup().getSortedIdFromUnsortedId(unsortedId);
        }
        return unsortedId;
    }
}

