/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.topn.TopNAlgorithmSelector;
import org.apache.druid.query.topn.TopNLexicographicResultBuilder;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.joda.time.DateTime;

public class LexicographicTopNMetricSpec
implements TopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private static Comparator<String> comparator = StringComparators.LEXICOGRAPHIC;
    private final String previousStop;

    @JsonCreator
    public LexicographicTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        this.previousStop = previousStop;
    }

    @Override
    public void verifyPreconditions(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
    }

    @JsonProperty
    public String getPreviousStop() {
        return this.previousStop;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return comparator;
    }

    @Override
    public TopNResultBuilder getResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        return new TopNLexicographicResultBuilder(timestamp, dimSpec, threshold, this.previousStop, comparator, aggFactories);
    }

    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.previousStop == null ? new byte[]{} : StringUtils.toUtf8((String)this.previousStop);
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)1).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        builder.skipTo(this.previousStop);
        builder.ignoreAfterThreshold();
        return builder;
    }

    @Override
    public void initTopNAlgorithmSelector(TopNAlgorithmSelector selector) {
        selector.setAggregateAllMetrics(true);
    }

    @Override
    public String getMetricName(DimensionSpec dimSpec) {
        return dimSpec.getOutputName();
    }

    @Override
    public boolean canBeOptimizedUnordered() {
        return false;
    }

    public String toString() {
        return "LexicographicTopNMetricSpec{previousStop='" + this.previousStop + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexicographicTopNMetricSpec that = (LexicographicTopNMetricSpec)o;
        return !(this.previousStop != null ? !this.previousStop.equals(that.previousStop) : that.previousStop != null);
    }

    public int hashCode() {
        return this.previousStop != null ? this.previousStop.hashCode() : 0;
    }
}

