/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.FunctionalExtraction;
import org.apache.druid.query.lookup.LookupExtractor;

public class LookupExtractionFn
extends FunctionalExtraction {
    private final LookupExtractor lookup;
    private final boolean optimize;

    @JsonCreator
    public LookupExtractionFn(final @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @JsonProperty(value="replaceMissingValueWith") @Nullable String replaceMissingValueWith, @JsonProperty(value="injective") @Nullable Boolean injective, @JsonProperty(value="optimize") @Nullable Boolean optimize) {
        super(new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                return lookup.apply(input);
            }
        }, retainMissingValue, replaceMissingValueWith, injective != null ? injective.booleanValue() : lookup.isOneToOne());
        this.lookup = lookup;
        this.optimize = optimize == null ? true : optimize;
    }

    @JsonProperty
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @Override
    @JsonProperty
    public boolean isRetainMissingValue() {
        return super.isRetainMissingValue();
    }

    @Override
    @JsonProperty
    public String getReplaceMissingValueWith() {
        return super.getReplaceMissingValueWith();
    }

    @Override
    @JsonProperty
    public boolean isInjective() {
        return super.isInjective();
    }

    @JsonProperty(value="optimize")
    public boolean isOptimize() {
        return this.optimize;
    }

    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(7);
            outputStream.write(this.lookup.getCacheKey());
            if (this.getReplaceMissingValueWith() != null) {
                outputStream.write(StringUtils.toUtf8((String)this.getReplaceMissingValueWith()));
                outputStream.write(255);
            }
            outputStream.write(this.isInjective() ? 1 : 0);
            outputStream.write(this.isRetainMissingValue() ? 1 : 0);
            outputStream.write(this.isOptimize() ? 1 : 0);
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupExtractionFn that = (LookupExtractionFn)o;
        if (this.isOptimize() != that.isOptimize()) {
            return false;
        }
        if (this.isRetainMissingValue() != that.isRetainMissingValue()) {
            return false;
        }
        if (this.isInjective() != that.isInjective()) {
            return false;
        }
        if (this.getLookup() != null ? !this.getLookup().equals(that.getLookup()) : that.getLookup() != null) {
            return false;
        }
        return this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().equals(that.getReplaceMissingValueWith()) : that.getReplaceMissingValueWith() == null;
    }

    public int hashCode() {
        int result = this.getLookup() != null ? this.getLookup().hashCode() : 0;
        result = 31 * result + (this.isOptimize() ? 1 : 0);
        result = 31 * result + (this.isRetainMissingValue() ? 1 : 0);
        result = 31 * result + (this.getReplaceMissingValueWith() != null ? this.getReplaceMissingValueWith().hashCode() : 0);
        result = 31 * result + (this.isInjective() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "LookupExtractionFn{lookup=" + this.lookup + ", optimize=" + this.optimize + ", retainMissingValue=" + this.isRetainMissingValue() + ", replaceMissingValueWith='" + this.getReplaceMissingValueWith() + '\'' + ", injective=" + this.isInjective() + '}';
    }
}

