/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.DateTime;

public final class ResultRow {
    private final Object[] row;

    private ResultRow(Object[] row) {
        this.row = row;
    }

    @JsonCreator
    public static ResultRow of(Object ... row) {
        return new ResultRow(row);
    }

    public static ResultRow create(int size) {
        return new ResultRow(new Object[size]);
    }

    public static ResultRow fromLegacyRow(Row row, GroupByQuery query) {
        ResultRow resultRow = ResultRow.create(query.getResultRowSizeWithPostAggregators());
        int i = 0;
        if (query.getResultRowHasTimestamp()) {
            resultRow.set(i++, row.getTimestamp().getMillis());
        }
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            resultRow.set(i++, row.getRaw(dimensionSpec.getOutputName()));
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            resultRow.set(i++, row.getRaw(aggregatorFactory.getName()));
        }
        for (PostAggregator postAggregator : query.getPostAggregatorSpecs()) {
            resultRow.set(i++, row.getRaw(postAggregator.getName()));
        }
        return resultRow;
    }

    @JsonValue
    public Object[] getArray() {
        return this.row;
    }

    public void set(int i, @Nullable Object o) {
        this.row[i] = o;
    }

    @Nullable
    public Object get(int i) {
        return this.row[i];
    }

    public long getLong(int i) {
        return ((Number)this.row[i]).longValue();
    }

    public int length() {
        return this.row.length;
    }

    public ResultRow copy() {
        Object[] newArray = new Object[this.row.length];
        System.arraycopy(this.row, 0, newArray, 0, this.row.length);
        return new ResultRow(newArray);
    }

    public Map<String, Object> toMap(GroupByQuery query) {
        RowSignature signature = query.getResultRowSignature();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = query.getResultRowDimensionStart(); i < this.row.length; ++i) {
            String columnName = signature.getColumnName(i);
            map.put(columnName, this.row[i]);
        }
        return map;
    }

    public MapBasedRow toMapBasedRow(GroupByQuery query) {
        DateTime timestamp = query.getResultRowHasTimestamp() ? query.getGranularity().toDateTime(this.getLong(0)) : query.getUniversalTimestamp();
        return new MapBasedRow(timestamp, this.toMap(query));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultRow resultRow = (ResultRow)o;
        return Arrays.equals(this.row, resultRow.row);
    }

    public int hashCode() {
        return Arrays.hashCode(this.row);
    }

    public String toString() {
        return "ResultRow{row=" + Arrays.toString(this.row) + '}';
    }
}

