/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;

public class VectorMatch
implements ReadableVectorMatch {
    private static final int[] DEFAULT_ALL_TRUE_VECTOR = new int[512];
    private static final VectorMatch ALL_FALSE = new VectorMatch(new int[0], 0);
    private final int[] selection;
    private int selectionSize;

    private VectorMatch(int[] selection, int selectionSize) {
        this.selection = selection;
        this.selectionSize = selectionSize;
    }

    public static ReadableVectorMatch allTrue(int numRows) {
        if (numRows <= DEFAULT_ALL_TRUE_VECTOR.length) {
            return new VectorMatch(DEFAULT_ALL_TRUE_VECTOR, numRows);
        }
        int[] selection = new int[numRows];
        for (int i = 0; i < numRows; ++i) {
            selection[i] = i;
        }
        return new VectorMatch(selection, numRows);
    }

    public static ReadableVectorMatch allFalse() {
        return ALL_FALSE;
    }

    public static VectorMatch wrap(int[] selection) {
        return new VectorMatch(selection, 0);
    }

    @Override
    public boolean isAllTrue(int vectorSize) {
        return this.selectionSize == vectorSize;
    }

    @Override
    public boolean isAllFalse() {
        return this.selectionSize == 0;
    }

    @Override
    public boolean isValid(@Nullable ReadableVectorMatch mask) {
        if (mask != null && !mask.isValid(null)) {
            return false;
        }
        int rowNum = -1;
        for (int i = 0; i < this.selectionSize; ++i) {
            if (this.selection[i] <= rowNum) {
                return false;
            }
            rowNum = this.selection[i];
        }
        if (rowNum > this.selection.length) {
            return false;
        }
        if (mask != null) {
            int[] maskArray = mask.getSelection();
            int j = 0;
            for (int i = 0; i < this.selectionSize; ++i) {
                while (j < mask.getSelectionSize() && this.selection[i] > maskArray[j]) {
                    ++j;
                }
                if (j < mask.getSelectionSize() && this.selection[i] == maskArray[j]) continue;
                return false;
            }
        }
        return true;
    }

    public VectorMatch removeAll(ReadableVectorMatch other) {
        Preconditions.checkState((this != other ? 1 : 0) != 0, (Object)"'other' must be a different instance from 'this'");
        int j = 0;
        int p = 0;
        int[] otherSelection = other.getSelection();
        for (int i = 0; i < this.selectionSize; ++i) {
            while (p < other.getSelectionSize() && otherSelection[p] < this.selection[i]) {
                ++p;
            }
            if (p < other.getSelectionSize() && otherSelection[p] == this.selection[i]) continue;
            this.selection[j++] = this.selection[i];
        }
        this.selectionSize = j;
        assert (this.isValid(null));
        return this;
    }

    public VectorMatch addAll(ReadableVectorMatch other, VectorMatch scratch) {
        Preconditions.checkState((this != scratch ? 1 : 0) != 0, (Object)"'scratch' must be a different instance from 'this'");
        Preconditions.checkState((other != scratch ? 1 : 0) != 0, (Object)"'scratch' must be a different instance from 'other'");
        Preconditions.checkState((this != other ? 1 : 0) != 0, (Object)"'other' must be a different instance from 'this'");
        int[] scratchSelection = scratch.getSelection();
        int[] otherSelection = other.getSelection();
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.selectionSize; ++i) {
            while (j < other.getSelectionSize() && otherSelection[j] < this.selection[i]) {
                scratchSelection[k++] = otherSelection[j++];
            }
            scratchSelection[k++] = this.selection[i];
            if (j >= other.getSelectionSize() || otherSelection[j] != this.selection[i]) continue;
            ++j;
        }
        while (j < other.getSelectionSize()) {
            scratchSelection[k++] = otherSelection[j++];
        }
        scratch.setSelectionSize(k);
        this.copyFrom(scratch);
        assert (this.isValid(null));
        return this;
    }

    public void copyFrom(ReadableVectorMatch other) {
        Preconditions.checkState((this != other ? 1 : 0) != 0, (Object)"'other' must be a different instance from 'this'");
        Preconditions.checkState((this.selection.length >= other.getSelectionSize() ? 1 : 0) != 0, (String)"Capacity[%s] cannot fit other match's selectionSize[%s]", (Object[])new Object[]{this.selection.length, other.getSelectionSize()});
        System.arraycopy(other.getSelection(), 0, this.selection, 0, other.getSelectionSize());
        this.selectionSize = other.getSelectionSize();
        assert (this.isValid(null));
    }

    @Override
    public int[] getSelection() {
        return this.selection;
    }

    @Override
    public int getSelectionSize() {
        return this.selectionSize;
    }

    public VectorMatch setSelectionSize(int newSelectionSize) {
        Preconditions.checkArgument((newSelectionSize <= this.selection.length ? 1 : 0) != 0, (String)"Oops! Cannot setSelectionSize[%s] > selection.length[%s].", (Object[])new Object[]{newSelectionSize, this.selection.length});
        this.selectionSize = newSelectionSize;
        assert (this.isValid(null));
        return this;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("[");
        for (int i = 0; i < this.selectionSize; ++i) {
            if (i > 0) {
                retVal.append(", ");
            }
            retVal.append(this.selection[i]);
        }
        retVal.append("]");
        return retVal.toString();
    }

    static {
        for (int i = 0; i < DEFAULT_ALL_TRUE_VECTOR.length; ++i) {
            VectorMatch.DEFAULT_ALL_TRUE_VECTOR[i] = i;
        }
    }
}

