/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.filter.Filters;

public class OrDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final List<DimFilter> fields;

    @JsonCreator
    public OrDimFilter(@JsonProperty(value="fields") List<DimFilter> fields) {
        fields = DimFilters.filterNulls(fields);
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"OR operator requires at least one field");
        this.fields = fields;
    }

    public OrDimFilter(DimFilter ... fields) {
        this(Arrays.asList(fields));
    }

    public OrDimFilter(String dimensionName, String value, String ... values) {
        this.fields = new ArrayList<DimFilter>(values.length + 1);
        this.fields.add(new SelectorDimFilter(dimensionName, value, null));
        for (String val : values) {
            this.fields.add(new SelectorDimFilter(dimensionName, val, null));
        }
    }

    @JsonProperty
    public List<DimFilter> getFields() {
        return this.fields;
    }

    public byte[] getCacheKey() {
        return DimFilterUtils.computeCacheKey((byte)2, this.fields);
    }

    @Override
    public DimFilter optimize() {
        List<DimFilter> newFields = DimFilters.optimize(this.fields);
        if (newFields.size() == 1) {
            return newFields.get(0);
        }
        return new OrDimFilter(newFields);
    }

    @Override
    public Filter toFilter() {
        return Filters.or(Filters.toFilters(this.fields));
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        TreeRangeSet retSet = TreeRangeSet.create();
        for (DimFilter field : this.fields) {
            RangeSet<String> rangeSet = field.getDimensionRangeSet(dimension);
            if (rangeSet == null) {
                return null;
            }
            retSet.addAll(rangeSet);
        }
        return retSet;
    }

    @Override
    public Set<String> getRequiredColumns() {
        HashSet<String> requiredColumns = new HashSet<String>();
        this.fields.forEach(field -> requiredColumns.addAll(field.getRequiredColumns()));
        return requiredColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrDimFilter that = (OrDimFilter)o;
        return !(this.fields != null ? !this.fields.equals(that.fields) : that.fields != null);
    }

    public int hashCode() {
        return this.fields != null ? this.fields.hashCode() : 0;
    }

    public String toString() {
        return StringUtils.format((String)"(%s)", (Object[])new Object[]{OR_JOINER.join(this.fields)});
    }
}

