/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;

@SubclassesMustOverrideEqualsAndHashCode
public class FilterTuning {
    private final boolean useBitmapIndex;
    @Nullable
    private final Integer minCardinalityToUseBitmapIndex;
    @Nullable
    private final Integer maxCardinalityToUseBitmapIndex;

    @JsonCreator
    public FilterTuning(@JsonProperty(value="useBitmapIndex") @Nullable Boolean useBitmapIndex, @JsonProperty(value="minCardinalityToUseBitmapIndex") @Nullable Integer minCardinalityToUseBitmapIndex, @JsonProperty(value="maxCardinalityToUseBitmapIndex") @Nullable Integer maxCardinalityToUseBitmapIndex) {
        this.useBitmapIndex = useBitmapIndex != null ? useBitmapIndex : true;
        this.minCardinalityToUseBitmapIndex = minCardinalityToUseBitmapIndex;
        this.maxCardinalityToUseBitmapIndex = maxCardinalityToUseBitmapIndex;
    }

    @JsonProperty
    public boolean getUseBitmapIndex() {
        return this.useBitmapIndex;
    }

    @Nullable
    @JsonProperty
    public Integer getMinCardinalityToUseBitmapIndex() {
        return this.minCardinalityToUseBitmapIndex;
    }

    @Nullable
    @JsonProperty
    public Integer getMaxCardinalityToUseBitmapIndex() {
        return this.maxCardinalityToUseBitmapIndex;
    }

    @JsonIgnore
    public boolean hasValueCardinalityThreshold() {
        return this.minCardinalityToUseBitmapIndex != null || this.maxCardinalityToUseBitmapIndex != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterTuning that = (FilterTuning)o;
        return Objects.equals(this.useBitmapIndex, that.useBitmapIndex) && Objects.equals(this.minCardinalityToUseBitmapIndex, that.minCardinalityToUseBitmapIndex) && Objects.equals(this.maxCardinalityToUseBitmapIndex, that.maxCardinalityToUseBitmapIndex);
    }

    public int hashCode() {
        return Objects.hash(this.useBitmapIndex, this.minCardinalityToUseBitmapIndex, this.maxCardinalityToUseBitmapIndex);
    }

    public String toString() {
        return "FilterTuning{useBitmapIndex=" + this.useBitmapIndex + ", minCardinalityToUseBitmapIndex=" + this.minCardinalityToUseBitmapIndex + ", maxCardinalityToUseBitmapIndex=" + this.maxCardinalityToUseBitmapIndex + '}';
    }
}

