/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongOutLongInFunctionVectorValueProcessor;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;

public class TimestampShiftExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_shift";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 3, 4);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampShiftExpr(args);
        }
        return new TimestampShiftDynamicExpr(args);
    }

    private static Period getPeriod(List<Expr> args, Expr.ObjectBinding bindings) {
        return new Period((Object)args.get(1).eval(bindings).asString());
    }

    private static int getStep(List<Expr> args, Expr.ObjectBinding bindings) {
        return args.get(2).eval(bindings).asInt();
    }

    private static ISOChronology getTimeZone(List<Expr> args, Expr.ObjectBinding bindings) {
        Expr timeZoneArg;
        Expr expr = timeZoneArg = args.size() > 3 ? args.get(3) : null;
        if (timeZoneArg == null) {
            return ISOChronology.getInstance(null);
        }
        String zone = timeZoneArg.eval(bindings).asString();
        return ISOChronology.getInstance((DateTimeZone)(zone != null ? DateTimes.inferTzFromString((String)zone) : null));
    }

    private static class TimestampShiftDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampShiftDynamicExpr(List<Expr> args) {
            super(TimestampShiftExprMacro.FN_NAME, args);
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval timestamp = ((Expr)this.args.get(0)).eval(bindings);
            if (timestamp.isNumericNull()) {
                return ExprEval.of(null);
            }
            Period period = TimestampShiftExprMacro.getPeriod(this.args, bindings);
            ISOChronology chronology = TimestampShiftExprMacro.getTimeZone(this.args, bindings);
            int step = TimestampShiftExprMacro.getStep(this.args, bindings);
            return ExprEval.of((long)chronology.add((ReadablePeriod)period, timestamp.asLong(), step));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            return shuttle.visit((Expr)new TimestampShiftDynamicExpr(shuttle.visitAll(this.args)));
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }

    private static class TimestampShiftExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Chronology chronology;
        private final Period period;
        private final int step;

        TimestampShiftExpr(List<Expr> args) {
            super(TimestampShiftExprMacro.FN_NAME, args);
            this.period = TimestampShiftExprMacro.getPeriod(args, InputBindings.nilBindings());
            this.chronology = TimestampShiftExprMacro.getTimeZone(args, InputBindings.nilBindings());
            this.step = TimestampShiftExprMacro.getStep(args, InputBindings.nilBindings());
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval timestamp = ((Expr)this.args.get(0)).eval(bindings);
            if (timestamp.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of((long)this.chronology.add((ReadablePeriod)this.period, timestamp.asLong(), this.step));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            return shuttle.visit((Expr)new TimestampShiftExpr(shuttle.visitAll(this.args)));
        }

        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        public <T> ExprVectorProcessor<T> buildVectorized(Expr.VectorInputBindingInspector inspector) {
            LongOutLongInFunctionVectorValueProcessor processor = new LongOutLongInFunctionVectorValueProcessor(CastToTypeVectorProcessor.cast((ExprVectorProcessor)((Expr)this.args.get(0)).buildVectorized(inspector), (ExpressionType)ExpressionType.LONG), inspector.getMaxVectorSize()){

                public long apply(long input) {
                    return chronology.add((ReadablePeriod)period, input, step);
                }
            };
            return processor;
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }
}

