/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

public class RegexpLikeExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "regexp_like";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        Expr arg = args.get(0);
        final Expr patternExpr = args.get(1);
        if (!ExprUtils.isStringLiteral(patternExpr)) {
            throw this.validationFailed("pattern must be a STRING literal", new Object[0]);
        }
        final Pattern pattern = Pattern.compile(StringUtils.nullToEmptyNonDruidDataString((String)((String)patternExpr.getLiteralValue())));
        class RegexpLikeExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            RegexpLikeExpr(Expr arg) {
                super(RegexpLikeExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String s = NullHandling.nullToEmptyIfNeeded((String)this.arg.eval(bindings).asString());
                if (s == null) {
                    return ExprEval.ofLongBoolean((boolean)false);
                }
                Matcher matcher = pattern.matcher(s);
                return ExprEval.ofLongBoolean((boolean)matcher.find());
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(RegexpLikeExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }

            public String stringify() {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{RegexpLikeExprMacro.FN_NAME, this.arg.stringify(), patternExpr.stringify()});
            }
        }
        return new RegexpLikeExpr(arg);
    }
}

