/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv4.IPv4Address;
import javax.annotation.Nullable;

public class IPv4AddressExprUtils {
    private static final IPAddressStringParameters IPV4_ADDRESS_PARAMS = new IPAddressStringParameters.Builder().allowSingleSegment(false).allow_inet_aton(false).allowIPv6(false).allowPrefix(false).allowEmpty(false).toParams();
    private static final IPAddressStringParameters IPV4_SUBNET_PARAMS = new IPAddressStringParameters.Builder().allowSingleSegment(false).allow_inet_aton(false).allowEmpty(false).allowIPv6(false).toParams();

    public static boolean overflowsUnsignedInt(long value) {
        return value < 0L || 0xFFFFFFFFL < value;
    }

    static boolean isValidIPv4Address(@Nullable String addressString) {
        return addressString != null && new IPAddressString(addressString, IPV4_ADDRESS_PARAMS).isIPv4();
    }

    static boolean isValidIPv4Subnet(@Nullable String subnetString) {
        return subnetString != null && new IPAddressString(subnetString, IPV4_SUBNET_PARAMS).isPrefixed();
    }

    @Nullable
    public static IPv4Address parse(@Nullable String string) {
        IPAddressString ipAddressString = new IPAddressString(string, IPV4_ADDRESS_PARAMS);
        if (ipAddressString.isIPv4()) {
            return ipAddressString.getAddress().toIPv4();
        }
        return null;
    }

    @Nullable
    public static IPAddressString parseString(@Nullable String string) {
        IPAddressString ipAddressString = new IPAddressString(string, IPV4_ADDRESS_PARAMS);
        if (ipAddressString.isIPv4()) {
            return ipAddressString;
        }
        return null;
    }

    @Nullable
    public static IPv4Address parse(long value) {
        if (!IPv4AddressExprUtils.overflowsUnsignedInt(value)) {
            return new IPv4Address((int)value);
        }
        return null;
    }

    public static String toString(IPv4Address address) {
        return address.toString();
    }

    public static long toLong(IPv4Address address) {
        return address.longValue();
    }
}

