/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.context;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.query.context.ResponseContext;

public class ResponseContextDeserializer
extends StdDeserializer<ResponseContext> {
    public ResponseContextDeserializer() {
        super(ResponseContext.class);
    }

    public ResponseContext deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.currentToken() != JsonToken.START_OBJECT) {
            throw ctxt.wrongTokenException(jp, ResponseContext.class, JsonToken.START_OBJECT, null);
        }
        ResponseContext retVal = ResponseContext.createEmpty();
        jp.nextToken();
        ResponseContext.Keys keys = ResponseContext.Keys.instance();
        while (jp.currentToken() == JsonToken.FIELD_NAME) {
            ResponseContext.Key key = keys.find(jp.getText());
            jp.nextToken();
            if (key == null) {
                this.skipValue(jp, jp.getText());
            } else {
                retVal.add(key, key.readValue(jp));
            }
            jp.nextToken();
        }
        if (jp.currentToken() != JsonToken.END_OBJECT) {
            throw ctxt.wrongTokenException(jp, ResponseContext.class, JsonToken.END_OBJECT, null);
        }
        return retVal;
    }

    private void skipValue(JsonParser jp, String key) throws IOException {
        JsonToken token = jp.currentToken();
        switch (token) {
            case START_OBJECT: {
                this.skipTo(jp, JsonToken.END_OBJECT);
                break;
            }
            case START_ARRAY: {
                this.skipTo(jp, JsonToken.END_ARRAY);
                break;
            }
            default: {
                if (token.isScalarValue()) {
                    return;
                }
                throw new JsonMappingException((Closeable)jp, "Invalid JSON inside unknown key: " + key);
            }
        }
    }

    private void skipTo(JsonParser jp, JsonToken end) throws IOException {
        block4: while (true) {
            jp.nextToken();
            JsonToken token = jp.currentToken();
            if (token == null) {
                throw new JsonMappingException((Closeable)jp, "Premature EOF");
            }
            switch (token) {
                case START_OBJECT: {
                    this.skipTo(jp, JsonToken.END_OBJECT);
                    continue block4;
                }
                case START_ARRAY: {
                    this.skipTo(jp, JsonToken.END_ARRAY);
                    continue block4;
                }
            }
            if (token == end) break;
        }
    }
}

