/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;

public abstract class NumericLastBufferAggregator<TSelector extends BaseNullableColumnValueSelector>
implements BufferAggregator {
    static final int NULL_OFFSET = 8;
    static final int VALUE_OFFSET = 9;
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    final TSelector valueSelector;

    public NumericLastBufferAggregator(BaseLongColumnValueSelector timeSelector, TSelector valueSelector) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract void putValue(ByteBuffer var1, int var2);

    boolean isValueNull(ByteBuffer buf, int position) {
        return buf.get(position + 8) == 1;
    }

    void updateTimeWithValue(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)0);
        this.putValue(buf, position + 9);
    }

    void updateTimeWithNull(ByteBuffer buf, int position, long time) {
        buf.putLong(position, time);
        buf.put(position + 8, (byte)1);
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, Long.MIN_VALUE);
        buf.put(position + 8, this.useDefault ? (byte)0 : 1);
        this.initValue(buf, position + 9);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        long lastTime;
        if (this.timeSelector.isNull()) {
            return;
        }
        long time = this.timeSelector.getLong();
        if (time >= (lastTime = buf.getLong(position))) {
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.updateTimeWithValue(buf, position, time);
            } else {
                this.updateTimeWithNull(buf, position, time);
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

