/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.vector;

import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.DoubleCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.FloatCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.LongCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.MultiValueStringCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.SingleValueStringCardinalityVectorProcessor;
import org.apache.druid.query.aggregation.cardinality.vector.StringObjectCardinalityVectorProcessor;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class CardinalityVectorProcessorFactory
implements VectorColumnProcessorFactory<CardinalityVectorProcessor> {
    public static final CardinalityVectorProcessorFactory INSTANCE = new CardinalityVectorProcessorFactory();

    @Override
    public CardinalityVectorProcessor makeSingleValueDimensionProcessor(ColumnCapabilities capabilities, SingleValueDimensionVectorSelector selector) {
        return new SingleValueStringCardinalityVectorProcessor(selector);
    }

    @Override
    public CardinalityVectorProcessor makeMultiValueDimensionProcessor(ColumnCapabilities capabilities, MultiValueDimensionVectorSelector selector) {
        return new MultiValueStringCardinalityVectorProcessor(selector);
    }

    @Override
    public CardinalityVectorProcessor makeFloatProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new FloatCardinalityVectorProcessor(selector);
    }

    @Override
    public CardinalityVectorProcessor makeDoubleProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new DoubleCardinalityVectorProcessor(selector);
    }

    @Override
    public CardinalityVectorProcessor makeLongProcessor(ColumnCapabilities capabilities, VectorValueSelector selector) {
        return new LongCardinalityVectorProcessor(selector);
    }

    @Override
    public CardinalityVectorProcessor makeObjectProcessor(ColumnCapabilities capabilities, VectorObjectSelector selector) {
        return new StringObjectCardinalityVectorProcessor(selector);
    }
}

