/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.types;

import com.google.common.hash.Hasher;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.segment.BaseFloatColumnValueSelector;

public class FloatCardinalityAggregatorColumnSelectorStrategy
implements CardinalityAggregatorColumnSelectorStrategy<BaseFloatColumnValueSelector> {
    public static void addFloatToCollector(HyperLogLogCollector collector, float n) {
        collector.add(CardinalityAggregator.HASH_FUNCTION.hashInt(Float.floatToIntBits(n)).asBytes());
    }

    @Override
    public void hashRow(BaseFloatColumnValueSelector selector, Hasher hasher) {
        if (NullHandling.replaceWithDefault() || !selector.isNull()) {
            hasher.putFloat(selector.getFloat());
        }
    }

    @Override
    public void hashValues(BaseFloatColumnValueSelector selector, HyperLogLogCollector collector) {
        if (NullHandling.replaceWithDefault() || !selector.isNull()) {
            FloatCardinalityAggregatorColumnSelectorStrategy.addFloatToCollector(collector, selector.getFloat());
        }
    }
}

