/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.any.NumericAnyBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongAnyBufferAggregator
extends NumericAnyBufferAggregator<BaseLongColumnValueSelector> {
    public LongAnyBufferAggregator(BaseLongColumnValueSelector valueSelector) {
        super(valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putLong(position + 1, 0L);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putLong(position + 1, ((BaseLongColumnValueSelector)this.valueSelector).getLong());
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean isNull = this.isValueNull(buf, position);
        return isNull ? null : Long.valueOf(buf.getLong(position + 1));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position + 1);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position + 1);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position + 1);
    }
}

