/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.druid.jackson.JodaStuff;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.context.ResponseContextDeserializer;
import org.joda.time.DateTimeZone;

public class DruidDefaultSerializersModule
extends SimpleModule {
    public DruidDefaultSerializersModule() {
        super("Druid default serializers");
        JodaStuff.register(this);
        this.addDeserializer(DateTimeZone.class, (JsonDeserializer)new JsonDeserializer<DateTimeZone>(){

            public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String tzId = jp.getText();
                return DateTimes.inferTzFromString((String)tzId);
            }
        });
        this.addSerializer(DateTimeZone.class, (JsonSerializer)new JsonSerializer<DateTimeZone>(){

            public void serialize(DateTimeZone dateTimeZone, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(dateTimeZone.getID());
            }
        });
        this.addSerializer(Sequence.class, (JsonSerializer)new JsonSerializer<Sequence>(){

            public void serialize(Sequence value, final JsonGenerator jgen, final SerializerProvider provider) throws IOException {
                jgen.writeStartArray();
                value.accumulate(null, (Accumulator)new Accumulator<Object, Object>(){
                    JsonSerializer<Object> serializer = null;
                    Class<?> serializerClass = null;

                    public Object accumulate(Object ignored, Object object) {
                        try {
                            if (object == null) {
                                jgen.writeNull();
                            } else {
                                Class<?> clazz = object.getClass();
                                if (this.serializerClass != clazz) {
                                    this.serializer = JacksonUtils.getSerializer((SerializerProvider)provider, clazz);
                                    this.serializerClass = clazz;
                                }
                                this.serializer.serialize(object, jgen, provider);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
                jgen.writeEndArray();
            }
        });
        this.addSerializer(Yielder.class, (JsonSerializer)new JsonSerializer<Yielder>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serialize(Yielder yielder, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                JsonSerializer serializer = null;
                Class<?> serializerClass = null;
                try {
                    jgen.writeStartArray();
                    while (!yielder.isDone()) {
                        Object o = yielder.get();
                        if (o == null) {
                            jgen.writeNull();
                        } else {
                            Class<?> clazz = o.getClass();
                            if (serializerClass != clazz) {
                                serializer = JacksonUtils.getSerializer((SerializerProvider)provider, clazz);
                                serializerClass = clazz;
                            }
                            serializer.serialize(o, jgen, provider);
                        }
                        yielder = yielder.next(null);
                    }
                    jgen.writeEndArray();
                }
                finally {
                    yielder.close();
                }
            }
        });
        this.addSerializer(ByteOrder.class, (JsonSerializer)ToStringSerializer.instance);
        this.addDeserializer(ByteOrder.class, (JsonDeserializer)new JsonDeserializer<ByteOrder>(){

            public ByteOrder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                if (ByteOrder.BIG_ENDIAN.toString().equals(jp.getText())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                return ByteOrder.LITTLE_ENDIAN;
            }
        });
        this.addDeserializer(ResponseContext.class, (JsonDeserializer)new ResponseContextDeserializer());
    }
}

