/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Injector;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.druid.guice.ExtensionFirstClassLoader;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;

public class ExtensionsLoader {
    private static final Logger log = new Logger(ExtensionsLoader.class);
    private final ExtensionsConfig extensionsConfig;
    private final ConcurrentHashMap<Pair<File, Boolean>, URLClassLoader> loaders = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Collection<?>> extensions = new ConcurrentHashMap();

    @Inject
    public ExtensionsLoader(ExtensionsConfig config) {
        this.extensionsConfig = config;
    }

    public static ExtensionsLoader instance(Injector injector) {
        return (ExtensionsLoader)injector.getInstance(ExtensionsLoader.class);
    }

    public ExtensionsConfig config() {
        return this.extensionsConfig;
    }

    public <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        Collection<?> retVal = this.extensions.get(clazz);
        if (retVal == null) {
            return Collections.emptySet();
        }
        return retVal;
    }

    public Collection<DruidModule> getLoadedModules() {
        return this.getLoadedImplementations(DruidModule.class);
    }

    @VisibleForTesting
    public Map<Pair<File, Boolean>, URLClassLoader> getLoadersMap() {
        return this.loaders;
    }

    public <T> Collection<T> getFromExtensions(Class<T> serviceClass) {
        Collection modules = this.extensions.computeIfAbsent(serviceClass, serviceC -> new ServiceLoadingFromExtensions((Class)serviceC).implsToLoad);
        return modules;
    }

    public Collection<DruidModule> getModules() {
        return this.getFromExtensions(DruidModule.class);
    }

    public File[] getExtensionFilesToLoad() {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(this.extensionsConfig.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", new Object[]{rootExtensionsDir});
        }
        LinkedHashSet<String> toLoad = this.extensionsConfig.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", new Object[]{extensionDir.getAbsolutePath()});
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public URLClassLoader getClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        return this.loaders.computeIfAbsent((Pair<File, Boolean>)Pair.of((Object)extension, (Object)useExtensionClassloaderFirst), k -> ExtensionsLoader.makeClassLoaderForExtension((File)k.lhs, (Boolean)k.rhs));
    }

    private static URLClassLoader makeClassLoaderForExtension(File extension, boolean useExtensionClassloaderFirst) {
        Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
        URL[] urls = new URL[jars.size()];
        try {
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.debug("added URL [%s] for extension [%s]", new Object[]{url, extension.getName()});
                urls[i++] = url;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (useExtensionClassloaderFirst) {
            return new ExtensionFirstClassLoader(urls, ExtensionsLoader.class.getClassLoader());
        }
        return new URLClassLoader(urls, ExtensionsLoader.class.getClassLoader());
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths) {
                File f = new File(path);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(path).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private class ServiceLoadingFromExtensions<T> {
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(Class<T> serviceClass) {
            this.serviceClass = serviceClass;
            if (ExtensionsLoader.this.extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : ExtensionsLoader.this.getExtensionFilesToLoad()) {
                log.debug("Loading extension [%s] for class [%s]", new Object[]{extension.getName(), this.serviceClass});
                try {
                    URLClassLoader loader = ExtensionsLoader.this.getClassLoaderForExtension(extension, ExtensionsLoader.this.extensionsConfig.isUseExtensionClassloaderFirst());
                    log.info("Loading extension [%s], jars: %s", new Object[]{extension.getName(), Arrays.stream(loader.getURLs()).map(u -> new File(u.getPath()).getName()).collect(Collectors.joining(", "))});
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getName();
            if (serviceImplName == null) {
                log.warn("Implementation [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", new Object[]{serviceImpl.getClass().getName()});
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.debug("Adding implementation [%s] for class [%s] from %s extension", new Object[]{serviceImplName, this.serviceClass, extensionType});
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }
}

