/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.StringFrameColumnWriter;
import org.apache.druid.segment.ColumnValueSelector;

class StringArrayFrameColumnWriter
extends StringFrameColumnWriter<ColumnValueSelector> {
    StringArrayFrameColumnWriter(ColumnValueSelector selector, MemoryAllocator allocator, boolean multiValue) {
        super(selector, allocator, multiValue);
        Preconditions.checkArgument((boolean)multiValue, (String)"%s can only be used when multiValue is true", (Object[])new Object[]{StringArrayFrameColumnWriter.class.getName()});
    }

    @Override
    public List<ByteBuffer> getUtf8ByteBuffersFromSelector(ColumnValueSelector selector) {
        return FrameWriterUtils.getUtf8ByteBuffersFromStringArraySelector(selector);
    }
}

