/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriter;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.frame.write.columnar.FrameColumnWriters;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class ColumnarFrameWriterFactory
implements FrameWriterFactory {
    private final MemoryAllocator allocator;
    private final RowSignature signature;
    private final List<SortColumn> sortColumns;

    public ColumnarFrameWriterFactory(MemoryAllocator allocator, RowSignature signature, List<SortColumn> sortColumns) {
        this.allocator = (MemoryAllocator)Preconditions.checkNotNull((Object)allocator, (Object)"allocator");
        this.signature = signature;
        this.sortColumns = (List)Preconditions.checkNotNull(sortColumns, (Object)"sortColumns");
        if (!sortColumns.isEmpty()) {
            throw new IAE("Columnar frames cannot be sorted", new Object[0]);
        }
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed field names: %s", new Object[]{disallowedFieldNames});
        }
    }

    @Override
    public FrameWriter newFrameWriter(ColumnSelectorFactory columnSelectorFactory) {
        ArrayList<FrameColumnWriter> columnWriters = new ArrayList<FrameColumnWriter>();
        try {
            for (int i = 0; i < this.signature.size(); ++i) {
                String column = this.signature.getColumnName(i);
                ColumnType columnType = this.signature.getColumnType(i).orElse(null);
                columnWriters.add(FrameColumnWriters.create(columnSelectorFactory, this.allocator, column, columnType));
            }
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, () -> CloseableUtils.closeAll((Iterable)columnWriters));
        }
        AppendableMemory rowOrderMemory = this.sortColumns.isEmpty() ? null : AppendableMemory.create(this.allocator);
        return new ColumnarFrameWriter(this.signature, this.sortColumns, rowOrderMemory, columnWriters);
    }

    @Override
    public long allocatorCapacity() {
        return this.allocator.capacity();
    }
}

