/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.RowBasedFrameWriterFactory;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriterFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameWriters {
    private FrameWriters() {
    }

    public static FrameWriterFactory makeFrameWriterFactory(FrameType frameType, MemoryAllocator allocator, RowSignature signature, List<SortColumn> sortColumns) {
        switch ((FrameType)((Object)Preconditions.checkNotNull((Object)((Object)frameType), (Object)"frameType"))) {
            case COLUMNAR: {
                return new ColumnarFrameWriterFactory(allocator, signature, sortColumns);
            }
            case ROW_BASED: {
                return new RowBasedFrameWriterFactory(allocator, signature, sortColumns);
            }
        }
        throw new ISE("Unrecognized frame type [%s]", new Object[]{frameType});
    }

    public static RowSignature sortableSignature(RowSignature signature, List<SortColumn> sortColumns) {
        RowSignature.Builder builder = RowSignature.builder();
        for (SortColumn columnName : sortColumns) {
            Optional<ColumnType> columnType = signature.getColumnType(columnName.columnName());
            if (!columnType.isPresent()) {
                throw new IAE("Column [%s] not present in signature", new Object[]{columnName});
            }
            builder.add(columnName.columnName(), columnType.get());
        }
        Set sortColumnNames = sortColumns.stream().map(SortColumn::columnName).collect(Collectors.toSet());
        for (int i = 0; i < signature.size(); ++i) {
            String columnName = signature.getColumnName(i);
            if (sortColumnNames.contains(columnName)) continue;
            builder.add(columnName, signature.getColumnType(i).orElse(null));
        }
        return builder.build();
    }
}

