/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReaderUtils;

public class RowKeyComparator
implements Comparator<RowKey> {
    private final int firstFieldPosition;
    private final int[] ascDescRunLengths;

    private RowKeyComparator(int firstFieldPosition, int[] ascDescRunLengths) {
        this.firstFieldPosition = firstFieldPosition;
        this.ascDescRunLengths = ascDescRunLengths;
    }

    public static RowKeyComparator create(List<SortColumn> keyColumns) {
        return new RowKeyComparator(RowKeyComparator.computeFirstFieldPosition(keyColumns.size()), RowKeyComparator.computeAscDescRunLengths(keyColumns));
    }

    public static int computeFirstFieldPosition(int fieldCount) {
        return Ints.checkedCast((long)((long)fieldCount * 4L));
    }

    public static int[] computeAscDescRunLengths(List<SortColumn> sortColumns) {
        IntArrayList ascDescRunLengths = new IntArrayList(4);
        boolean descending = false;
        int runLength = 0;
        for (SortColumn column : sortColumns) {
            if (column.descending() != descending) {
                ascDescRunLengths.add(runLength);
                runLength = 0;
                descending = !descending;
            }
            ++runLength;
        }
        if (runLength > 0) {
            ascDescRunLengths.add(runLength);
        }
        return ascDescRunLengths.toIntArray();
    }

    @Override
    public int compare(RowKey key1, RowKey key2) {
        byte[] keyArray1 = key1.array();
        byte[] keyArray2 = key2.array();
        int comparableBytesStartPosition1 = this.firstFieldPosition;
        int comparableBytesStartPosition2 = this.firstFieldPosition;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int comparableBytesEndPosition2;
                int nextField = field + numFields;
                int comparableBytesEndPosition1 = RowKeyReader.fieldEndPosition(keyArray1, nextField - 1);
                int cmp = FrameReaderUtils.compareByteArraysUnsigned(keyArray1, comparableBytesStartPosition1, comparableBytesEndPosition1 - comparableBytesStartPosition1, keyArray2, comparableBytesStartPosition2, (comparableBytesEndPosition2 = RowKeyReader.fieldEndPosition(keyArray2, nextField - 1)) - comparableBytesStartPosition2);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field = nextField;
                comparableBytesStartPosition1 = comparableBytesEndPosition1;
                comparableBytesStartPosition2 = comparableBytesEndPosition2;
            }
            ascending = !ascending;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowKeyComparator that = (RowKeyComparator)o;
        return this.firstFieldPosition == that.firstFieldPosition && Arrays.equals(this.ascDescRunLengths, that.ascDescRunLengths);
    }

    public int hashCode() {
        int result = Objects.hash(this.firstFieldPosition);
        result = 31 * result + Arrays.hashCode(this.ascDescRunLengths);
        return result;
    }

    public String toString() {
        return "RowKeyComparator{firstFieldPosition=" + this.firstFieldPosition + ", ascDescRunLengths=" + Arrays.toString(this.ascDescRunLengths) + '}';
    }
}

