/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.HeapMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.ISE;

public class FrameFileWriter
implements Closeable {
    public static final byte[] MAGIC = new byte[]{-1, 1};
    public static final byte MARKER_FRAME = 1;
    public static final byte MARKER_NO_MORE_FRAMES = 2;
    public static final int TRAILER_LENGTH = 16;
    public static final int CHECKSUM_SEED = 0;
    public static final int NO_PARTITION = -1;
    private final WritableByteChannel channel;
    private final AppendableMemory tableOfContents;
    private final AppendableMemory partitions;
    private long bytesWritten = 0L;
    private int numFrames = 0;
    private boolean usePartitions = true;
    private ByteBuffer compressionBuffer;
    private boolean closed = false;

    private FrameFileWriter(WritableByteChannel channel, @Nullable ByteBuffer compressionBuffer, AppendableMemory tableOfContents, AppendableMemory partitions) {
        this.channel = channel;
        this.compressionBuffer = compressionBuffer;
        this.tableOfContents = tableOfContents;
        this.partitions = partitions;
    }

    public static FrameFileWriter open(WritableByteChannel channel, @Nullable ByteBuffer compressionBuffer) {
        HeapMemoryAllocator allocator = HeapMemoryAllocator.unlimited();
        return new FrameFileWriter(channel, compressionBuffer, AppendableMemory.create(allocator), AppendableMemory.create(allocator));
    }

    public void writeFrame(Frame frame, int partition) throws IOException {
        if (this.numFrames == Integer.MAX_VALUE) {
            throw new ISE("Too many frames", new Object[0]);
        }
        if (partition < 0 && this.numFrames == 0) {
            this.usePartitions = false;
        }
        if (partition >= 0 != this.usePartitions) {
            throw new ISE("Cannot mix partitioned and non-partitioned data", new Object[0]);
        }
        if (!this.tableOfContents.reserveAdditional(8)) {
            throw new ISE("Too many frames", new Object[0]);
        }
        this.writeMagicIfNeeded();
        Channels.writeFully((WritableByteChannel)this.channel, (ByteBuffer)ByteBuffer.wrap(new byte[]{1}));
        ++this.bytesWritten;
        this.bytesWritten += frame.writeTo(this.channel, true, this.getCompressionBuffer(frame.numBytes()));
        MemoryRange<WritableMemory> tocCursor = this.tableOfContents.cursor();
        tocCursor.memory().putLong(tocCursor.start(), this.bytesWritten);
        this.tableOfContents.advanceCursor(8);
        if (this.usePartitions) {
            int highestPartitionWritten = Ints.checkedCast((long)(this.partitions.size() / 4L)) - 1;
            if (partition < highestPartitionWritten) {
                throw new ISE("Partition [%,d] < highest partition [%,d]", new Object[]{partition, highestPartitionWritten});
            }
            while (partition > highestPartitionWritten) {
                if (!this.partitions.reserveAdditional(4)) {
                    throw new ISE("Too many partitions", new Object[0]);
                }
                MemoryRange<WritableMemory> partitionCursor = this.partitions.cursor();
                ++highestPartitionWritten;
                partitionCursor.memory().putInt(partitionCursor.start(), this.numFrames);
                this.partitions.advanceCursor(4);
            }
        }
        ++this.numFrames;
    }

    public void abort() throws IOException {
        if (!this.closed) {
            this.partitions.close();
            this.tableOfContents.close();
            this.channel.close();
            this.compressionBuffer = null;
            this.closed = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeMagicIfNeeded();
        if (!this.tableOfContents.reserveAdditional(12)) {
            throw new ISE("Can't finish table of contents", new Object[0]);
        }
        MemoryRange<WritableMemory> tocCursor = this.tableOfContents.cursor();
        int numPartitions = Ints.checkedCast((long)(this.partitions.size() / 4L));
        tocCursor.memory().putInt(tocCursor.start(), this.numFrames);
        tocCursor.memory().putInt(tocCursor.start() + 4L, numPartitions);
        tocCursor.memory().putInt(tocCursor.start() + 8L, FrameFileWriter.footerLength(this.numFrames, numPartitions));
        this.tableOfContents.advanceCursor(12);
        ByteBuffer footerBuf = ByteBuffer.allocate(FrameFileWriter.footerLength(this.numFrames, numPartitions));
        WritableMemory footerMemory = WritableMemory.writableWrap((ByteBuffer)footerBuf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        assert (1L + this.partitions.size() + this.tableOfContents.size() + 4L == footerMemory.getCapacity());
        long p = 1L;
        footerMemory.putByte(0L, (byte)2);
        p += this.partitions.writeTo(footerMemory, p);
        this.partitions.close();
        p += this.tableOfContents.writeTo(footerMemory, p);
        this.tableOfContents.close();
        int checksum = (int)footerMemory.xxHash64(0L, p, 0L);
        footerMemory.putInt(p, checksum);
        Channels.writeFully((WritableByteChannel)this.channel, (ByteBuffer)footerBuf);
        this.channel.close();
        this.compressionBuffer = null;
        this.closed = true;
    }

    private void writeMagicIfNeeded() throws IOException {
        if (this.numFrames == 0) {
            Channels.writeFully((WritableByteChannel)this.channel, (ByteBuffer)ByteBuffer.wrap(MAGIC));
            this.bytesWritten += (long)MAGIC.length;
        }
    }

    private ByteBuffer getCompressionBuffer(long frameSize) {
        int requiredSize = Frame.compressionBufferSize(frameSize);
        if (this.compressionBuffer == null || this.compressionBuffer.capacity() < requiredSize) {
            this.compressionBuffer = ByteBuffer.allocate(requiredSize);
        }
        return this.compressionBuffer;
    }

    static int footerLength(int numFrames, int numPartitions) {
        return Ints.checkedCast((long)(1L + 4L * (long)numPartitions + 8L * (long)numFrames + 16L));
    }
}

