/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.RowMemoryFieldPointer;
import org.apache.druid.frame.segment.row.ConstantFrameRowPointer;

public class RowReader {
    private final List<FieldReader> fieldReaders;

    public RowReader(List<FieldReader> fieldReaders) {
        this.fieldReaders = fieldReaders;
    }

    public FieldReader fieldReader(int fieldNumber) {
        return this.fieldReaders.get(fieldNumber);
    }

    public int fieldCount() {
        return this.fieldReaders.size();
    }

    public Object readField(Memory memory, long rowPosition, long rowLength, int fieldNumber) {
        return this.fieldReaders.get(fieldNumber).makeColumnValueSelector(memory, new RowMemoryFieldPointer(memory, new ConstantFrameRowPointer(rowPosition, rowLength), fieldNumber, this.fieldReaders.size())).getObject();
    }

    public List<Object> readRow(Memory memory, long rowPosition, long rowLength) {
        ArrayList<Object> objects = new ArrayList<Object>(this.fieldReaders.size());
        for (int i = 0; i < this.fieldReaders.size(); ++i) {
            objects.add(this.readField(memory, rowPosition, rowLength, i));
        }
        return objects;
    }
}

