/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.file.FrameFileWriter;

public class WritableFrameFileChannel
implements WritableFrameChannel {
    private final FrameFileWriter writer;

    public WritableFrameFileChannel(FrameFileWriter writer) {
        this.writer = writer;
    }

    @Override
    public void write(FrameWithPartition frame) throws IOException {
        this.writer.writeFrame(frame.frame(), frame.partition());
    }

    @Override
    public void fail(@Nullable Throwable cause) throws IOException {
        this.writer.abort();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public ListenableFuture<?> writabilityFuture() {
        return Futures.immediateFuture((Object)true);
    }
}

