/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import java.io.Closeable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.guava.BaseSequence;

public class FrameChannelSequence
extends BaseSequence<Frame, FrameChannelIterator> {
    public FrameChannelSequence(final ReadableFrameChannel channel) {
        super((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Frame, FrameChannelIterator>(){

            public FrameChannelIterator make() {
                return new FrameChannelIterator(channel);
            }

            public void cleanup(FrameChannelIterator iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    public static class FrameChannelIterator
    implements Iterator<Frame>,
    Closeable {
        private final ReadableFrameChannel channel;

        private FrameChannelIterator(ReadableFrameChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean hasNext() {
            this.await();
            return !this.channel.isFinished();
        }

        @Override
        public Frame next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.channel.read();
        }

        @Override
        public void close() {
            this.channel.close();
        }

        private void await() {
            FutureUtils.getUnchecked(this.channel.readabilityFuture(), (boolean)false);
        }
    }
}

