/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.java.util.common.ISE;

public class ArenaMemoryAllocator
implements MemoryAllocator {
    private final WritableMemory arena;
    private long allocations = 0L;
    private long position = 0L;

    private ArenaMemoryAllocator(WritableMemory arena) {
        this.arena = (WritableMemory)Preconditions.checkNotNull((Object)arena, (Object)"arena");
    }

    public static ArenaMemoryAllocator create(ByteBuffer buffer) {
        return new ArenaMemoryAllocator(WritableMemory.writableWrap((ByteBuffer)buffer.slice()));
    }

    public static ArenaMemoryAllocator createOnHeap(int capacity) {
        return ArenaMemoryAllocator.create(ByteBuffer.allocate(capacity));
    }

    @Override
    public Optional<ResourceHolder<WritableMemory>> allocate(final long size) {
        if (this.position + size < this.arena.getCapacity()) {
            final long start = this.position;
            ++this.allocations;
            this.position += size;
            return Optional.of(new ResourceHolder<WritableMemory>(){
                private WritableMemory memory;
                {
                    this.memory = ArenaMemoryAllocator.this.arena.writableRegion(start, size, ByteOrder.LITTLE_ENDIAN);
                }

                public WritableMemory get() {
                    if (this.memory == null) {
                        throw new ISE("Already closed", new Object[0]);
                    }
                    return this.memory;
                }

                public void close() {
                    this.memory = null;
                    if (--ArenaMemoryAllocator.this.allocations == 0L) {
                        ArenaMemoryAllocator.this.position = 0L;
                    }
                }
            });
        }
        return Optional.empty();
    }

    @Override
    public long available() {
        return this.arena.getCapacity() - this.position;
    }

    @Override
    public long capacity() {
        return this.arena.getCapacity();
    }
}

