/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.AutoScalerConfig;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.LagBasedAutoScaler;

public class LagBasedAutoScalerConfig
implements AutoScalerConfig {
    private final long lagCollectionIntervalMillis;
    private final long lagCollectionRangeMillis;
    private final long scaleActionStartDelayMillis;
    private final long scaleActionPeriodMillis;
    private final long scaleOutThreshold;
    private final long scaleInThreshold;
    private final double triggerScaleOutFractionThreshold;
    private final double triggerScaleInFractionThreshold;
    private int taskCountMax;
    private int taskCountMin;
    private final int scaleInStep;
    private final int scaleOutStep;
    private final boolean enableTaskAutoScaler;
    private final long minTriggerScaleActionFrequencyMillis;

    @JsonCreator
    public LagBasedAutoScalerConfig(@Nullable @JsonProperty(value="lagCollectionIntervalMillis") Long lagCollectionIntervalMillis, @Nullable @JsonProperty(value="lagCollectionRangeMillis") Long lagCollectionRangeMillis, @Nullable @JsonProperty(value="scaleActionStartDelayMillis") Long scaleActionStartDelayMillis, @Nullable @JsonProperty(value="scaleActionPeriodMillis") Long scaleActionPeriodMillis, @Nullable @JsonProperty(value="scaleOutThreshold") Long scaleOutThreshold, @Nullable @JsonProperty(value="scaleInThreshold") Long scaleInThreshold, @Nullable @JsonProperty(value="triggerScaleOutFractionThreshold") Double triggerScaleOutFractionThreshold, @Nullable @JsonProperty(value="triggerScaleInFractionThreshold") Double triggerScaleInFractionThreshold, @JsonProperty(value="taskCountMax") Integer taskCountMax, @JsonProperty(value="taskCountMin") Integer taskCountMin, @Nullable @JsonProperty(value="scaleInStep") Integer scaleInStep, @Nullable @JsonProperty(value="scaleOutStep") Integer scaleOutStep, @Nullable @JsonProperty(value="enableTaskAutoScaler") Boolean enableTaskAutoScaler, @Nullable @JsonProperty(value="minTriggerScaleActionFrequencyMillis") Long minTriggerScaleActionFrequencyMillis) {
        this.enableTaskAutoScaler = enableTaskAutoScaler != null ? enableTaskAutoScaler : false;
        this.lagCollectionIntervalMillis = lagCollectionIntervalMillis != null ? lagCollectionIntervalMillis : 30000L;
        this.lagCollectionRangeMillis = lagCollectionRangeMillis != null ? lagCollectionRangeMillis : 600000L;
        this.scaleActionStartDelayMillis = scaleActionStartDelayMillis != null ? scaleActionStartDelayMillis : 300000L;
        this.scaleActionPeriodMillis = scaleActionPeriodMillis != null ? scaleActionPeriodMillis : 60000L;
        this.scaleOutThreshold = scaleOutThreshold != null ? scaleOutThreshold : 6000000L;
        this.scaleInThreshold = scaleInThreshold != null ? scaleInThreshold : 1000000L;
        this.triggerScaleOutFractionThreshold = triggerScaleOutFractionThreshold != null ? triggerScaleOutFractionThreshold : 0.3;
        double d = this.triggerScaleInFractionThreshold = triggerScaleInFractionThreshold != null ? triggerScaleInFractionThreshold : 0.9;
        if (this.enableTaskAutoScaler) {
            if (taskCountMax == null || taskCountMin == null) {
                throw new RuntimeException("taskCountMax or taskCountMin can't be null!");
            }
            if (taskCountMax < taskCountMin) {
                throw new RuntimeException("taskCountMax can't lower than taskCountMin!");
            }
            this.taskCountMax = taskCountMax;
            this.taskCountMin = taskCountMin;
        }
        this.scaleInStep = scaleInStep != null ? scaleInStep : 1;
        this.scaleOutStep = scaleOutStep != null ? scaleOutStep : 2;
        this.minTriggerScaleActionFrequencyMillis = minTriggerScaleActionFrequencyMillis != null ? minTriggerScaleActionFrequencyMillis : 600000L;
    }

    @JsonProperty
    public long getLagCollectionIntervalMillis() {
        return this.lagCollectionIntervalMillis;
    }

    @JsonProperty
    public long getLagCollectionRangeMillis() {
        return this.lagCollectionRangeMillis;
    }

    @JsonProperty
    public long getScaleActionStartDelayMillis() {
        return this.scaleActionStartDelayMillis;
    }

    @JsonProperty
    public long getScaleActionPeriodMillis() {
        return this.scaleActionPeriodMillis;
    }

    @JsonProperty
    public long getScaleOutThreshold() {
        return this.scaleOutThreshold;
    }

    @JsonProperty
    public long getScaleInThreshold() {
        return this.scaleInThreshold;
    }

    @JsonProperty
    public double getTriggerScaleOutFractionThreshold() {
        return this.triggerScaleOutFractionThreshold;
    }

    @JsonProperty
    public double getTriggerScaleInFractionThreshold() {
        return this.triggerScaleInFractionThreshold;
    }

    @Override
    @JsonProperty
    public int getTaskCountMax() {
        return this.taskCountMax;
    }

    @Override
    @JsonProperty
    public int getTaskCountMin() {
        return this.taskCountMin;
    }

    @Override
    public SupervisorTaskAutoScaler createAutoScaler(Supervisor supervisor, SupervisorSpec spec) {
        return new LagBasedAutoScaler((SeekableStreamSupervisor)supervisor, spec.getId(), this, spec);
    }

    @JsonProperty
    public int getScaleInStep() {
        return this.scaleInStep;
    }

    @JsonProperty
    public int getScaleOutStep() {
        return this.scaleOutStep;
    }

    @Override
    @JsonProperty
    public boolean getEnableTaskAutoScaler() {
        return this.enableTaskAutoScaler;
    }

    @Override
    @JsonProperty
    public long getMinTriggerScaleActionFrequencyMillis() {
        return this.minTriggerScaleActionFrequencyMillis;
    }

    public String toString() {
        return "autoScalerConfig{enableTaskAutoScaler=" + this.enableTaskAutoScaler + ", taskCountMax=" + this.taskCountMax + ", taskCountMin=" + this.taskCountMin + ", minTriggerScaleActionFrequencyMillis=" + this.minTriggerScaleActionFrequencyMillis + ", lagCollectionIntervalMillis=" + this.lagCollectionIntervalMillis + ", lagCollectionIntervalMillis=" + this.lagCollectionIntervalMillis + ", scaleOutThreshold=" + this.scaleOutThreshold + ", triggerScaleOutFractionThreshold=" + this.triggerScaleOutFractionThreshold + ", scaleInThreshold=" + this.scaleInThreshold + ", triggerScaleInFractionThreshold=" + this.triggerScaleInFractionThreshold + ", scaleActionStartDelayMillis=" + this.scaleActionStartDelayMillis + ", scaleActionPeriodMillis=" + this.scaleActionPeriodMillis + ", scaleInStep=" + this.scaleInStep + ", scaleOutStep=" + this.scaleOutStep + '}';
    }
}

