/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.java.util.common.IAE;

public class SeekableStreamEndSequenceNumbers<PartitionIdType, SequenceOffsetType>
implements SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> {
    private final String stream;
    private final Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap;

    @JsonCreator
    public SeekableStreamEndSequenceNumbers(@JsonProperty(value="stream") String stream, @JsonProperty(value="topic") String topic, @JsonProperty(value="partitionSequenceNumberMap") Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap, @JsonProperty(value="partitionOffsetMap") Map<PartitionIdType, SequenceOffsetType> partitionOffsetMap) {
        this.stream = stream == null ? topic : stream;
        this.partitionSequenceNumberMap = partitionOffsetMap == null ? partitionSequenceNumberMap : partitionOffsetMap;
        Preconditions.checkNotNull((Object)this.stream, (Object)"stream");
        Preconditions.checkNotNull(this.partitionSequenceNumberMap, (Object)"partitionIdToSequenceNumberMap");
    }

    public SeekableStreamEndSequenceNumbers(String stream, Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap) {
        this(stream, null, partitionSequenceNumberMap, null);
    }

    public SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType> asStartPartitions(boolean isExclusiveEndOffset) {
        return new SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType>(this.stream, this.partitionSequenceNumberMap, isExclusiveEndOffset ? Collections.emptySet() : this.partitionSequenceNumberMap.keySet());
    }

    @Override
    @JsonProperty
    public String getStream() {
        return this.stream;
    }

    @JsonProperty
    public String getTopic() {
        return this.stream;
    }

    @Override
    @JsonProperty
    public Map<PartitionIdType, SequenceOffsetType> getPartitionSequenceNumberMap() {
        return this.partitionSequenceNumberMap;
    }

    @Override
    public SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> plus(SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> other) {
        if (this.getClass() != other.getClass()) {
            throw new IAE("Expected instance of %s, got %s", new Object[]{this.getClass().getName(), other.getClass().getName()});
        }
        SeekableStreamEndSequenceNumbers otherEnd = (SeekableStreamEndSequenceNumbers)other;
        if (this.stream.equals(otherEnd.stream)) {
            HashMap<PartitionIdType, SequenceOffsetType> newMap = new HashMap<PartitionIdType, SequenceOffsetType>(this.partitionSequenceNumberMap);
            newMap.putAll(otherEnd.partitionSequenceNumberMap);
            return new SeekableStreamEndSequenceNumbers<PartitionIdType, SequenceOffsetType>(this.stream, newMap);
        }
        return other;
    }

    @Override
    public SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> minus(SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> other) {
        if (this.getClass() != other.getClass()) {
            throw new IAE("Expected instance of %s, got %s", new Object[]{this.getClass().getName(), other.getClass().getName()});
        }
        SeekableStreamEndSequenceNumbers otherEnd = (SeekableStreamEndSequenceNumbers)other;
        if (this.stream.equals(otherEnd.stream)) {
            HashMap<PartitionIdType, SequenceOffsetType> newMap = new HashMap<PartitionIdType, SequenceOffsetType>();
            for (Map.Entry<PartitionIdType, SequenceOffsetType> entry : this.partitionSequenceNumberMap.entrySet()) {
                if (otherEnd.partitionSequenceNumberMap.containsKey(entry.getKey())) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            return new SeekableStreamEndSequenceNumbers(this.stream, newMap);
        }
        return this;
    }

    @JsonProperty
    public Map<PartitionIdType, SequenceOffsetType> getPartitionOffsetMap() {
        return this.partitionSequenceNumberMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeekableStreamEndSequenceNumbers that = (SeekableStreamEndSequenceNumbers)o;
        return Objects.equals(this.stream, that.stream) && Objects.equals(this.partitionSequenceNumberMap, that.partitionSequenceNumberMap);
    }

    public int hashCode() {
        return Objects.hash(this.stream, this.partitionSequenceNumberMap);
    }

    public String toString() {
        return "SeekableStreamEndSequenceNumbers{stream='" + this.stream + '\'' + ", partitionSequenceNumberMap=" + this.partitionSequenceNumberMap + '}';
    }
}

