/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.indexing.overlord.autoscaling.AutoScaler;
import org.apache.druid.indexing.overlord.autoscaling.NoopAutoScaler;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.setup.WorkerSelectStrategy;

public class DefaultWorkerBehaviorConfig
implements WorkerBehaviorConfig {
    private static final AutoScaler DEFAULT_AUTOSCALER = new NoopAutoScaler();
    private final WorkerSelectStrategy selectStrategy;
    private final AutoScaler autoScaler;

    public static DefaultWorkerBehaviorConfig defaultConfig() {
        return new DefaultWorkerBehaviorConfig(DEFAULT_STRATEGY, DEFAULT_AUTOSCALER);
    }

    @JsonCreator
    public DefaultWorkerBehaviorConfig(@JsonProperty(value="selectStrategy") WorkerSelectStrategy selectStrategy, @JsonProperty(value="autoScaler") AutoScaler autoScaler) {
        this.selectStrategy = selectStrategy;
        this.autoScaler = autoScaler;
    }

    @Override
    @JsonProperty
    public WorkerSelectStrategy getSelectStrategy() {
        return this.selectStrategy;
    }

    @JsonProperty
    public AutoScaler<?> getAutoScaler() {
        return this.autoScaler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultWorkerBehaviorConfig that = (DefaultWorkerBehaviorConfig)o;
        if (this.autoScaler != null ? !this.autoScaler.equals(that.autoScaler) : that.autoScaler != null) {
            return false;
        }
        return !(this.selectStrategy != null ? !this.selectStrategy.equals(that.selectStrategy) : that.selectStrategy != null);
    }

    public int hashCode() {
        int result = this.selectStrategy != null ? this.selectStrategy.hashCode() : 0;
        result = 31 * result + (this.autoScaler != null ? this.autoScaler.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkerConfiguration{selectStrategy=" + this.selectStrategy + ", autoScaler=" + this.autoScaler + '}';
    }
}

