/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.joda.time.DateTime;

public class ZkWorker
implements Closeable {
    private final PathChildrenCache statusCache;
    private final Function<ChildData, TaskAnnouncement> cacheConverter;
    private final java.util.function.Function<ChildData, String> taskIdExtractor;
    private AtomicReference<Worker> worker;
    private AtomicReference<DateTime> lastCompletedTaskTime = new AtomicReference<DateTime>(DateTimes.nowUtc());
    private AtomicReference<DateTime> blacklistedUntil = new AtomicReference();
    private AtomicInteger continuouslyFailedTasksCount = new AtomicInteger(0);

    public ZkWorker(Worker worker, PathChildrenCache statusCache, ObjectMapper jsonMapper) {
        this.worker = new AtomicReference<Worker>(worker);
        this.statusCache = statusCache;
        this.cacheConverter = input -> (TaskAnnouncement)JacksonUtils.readValue((ObjectMapper)jsonMapper, (byte[])input.getData(), TaskAnnouncement.class);
        this.taskIdExtractor = ZkWorker.createTaskIdExtractor(jsonMapper);
    }

    static java.util.function.Function<ChildData, String> createTaskIdExtractor(ObjectMapper jsonMapper) {
        return input -> {
            try (JsonParser parser = jsonMapper.getFactory().createParser(input.getData());){
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    String currentName = parser.getCurrentName();
                    if (currentName == null) continue;
                    switch (currentName) {
                        case "id": {
                            parser.nextToken();
                            String string = parser.getValueAsString();
                            return string;
                        }
                    }
                    parser.skipChildren();
                }
                String string = null;
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void start() throws Exception {
        this.statusCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
    }

    public void addListener(PathChildrenCacheListener listener) {
        this.statusCache.getListenable().addListener((Object)listener);
    }

    @JsonProperty(value="worker")
    public Worker getWorker() {
        return this.worker.get();
    }

    @JsonProperty(value="runningTasks")
    public Collection<String> getRunningTaskIds() {
        return this.statusCache.getCurrentData().stream().map(this.taskIdExtractor).collect(Collectors.toSet());
    }

    public Map<String, TaskAnnouncement> getRunningTasks() {
        HashMap<String, TaskAnnouncement> retVal = new HashMap<String, TaskAnnouncement>();
        for (TaskAnnouncement taskAnnouncement : Lists.transform((List)this.statusCache.getCurrentData(), this.cacheConverter)) {
            retVal.put(taskAnnouncement.getTaskStatus().getId(), taskAnnouncement);
        }
        return retVal;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        return ZkWorker.getCurrCapacityUsed(this.getRunningTasks());
    }

    private static int getCurrCapacityUsed(Map<String, TaskAnnouncement> tasks) {
        int currCapacity = 0;
        for (TaskAnnouncement taskAnnouncement : tasks.values()) {
            currCapacity += taskAnnouncement.getTaskResource().getRequiredCapacity();
        }
        return currCapacity;
    }

    @JsonProperty(value="currParallelIndexCapacityUsed")
    public int getCurrParallelIndexCapacityUsed() {
        return this.getCurrParallelIndexCapacityUsed(this.getRunningTasks());
    }

    private int getCurrParallelIndexCapacityUsed(Map<String, TaskAnnouncement> tasks) {
        int currParallelIndexCapacityUsed = 0;
        for (TaskAnnouncement taskAnnouncement : tasks.values()) {
            if (!taskAnnouncement.getTaskType().equals("index_parallel")) continue;
            currParallelIndexCapacityUsed += taskAnnouncement.getTaskResource().getRequiredCapacity();
        }
        return currParallelIndexCapacityUsed;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        return ZkWorker.getAvailabilityGroups(this.getRunningTasks());
    }

    private static Set<String> getAvailabilityGroups(Map<String, TaskAnnouncement> tasks) {
        HashSet<String> retVal = new HashSet<String>();
        for (TaskAnnouncement taskAnnouncement : tasks.values()) {
            retVal.add(taskAnnouncement.getTaskResource().getAvailabilityGroup());
        }
        return retVal;
    }

    @JsonProperty
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime.get();
    }

    @JsonProperty
    public DateTime getBlacklistedUntil() {
        return this.blacklistedUntil.get();
    }

    public boolean isRunningTask(String taskId) {
        return this.statusCache.getCurrentData().stream().map(this.taskIdExtractor).anyMatch(s -> taskId.equals(s));
    }

    public boolean isValidVersion(String minVersion) {
        return this.worker.get().getVersion().compareTo(minVersion) >= 0;
    }

    public void setWorker(Worker newWorker) {
        Worker oldWorker = this.worker.get();
        Preconditions.checkArgument((boolean)newWorker.getHost().equals(oldWorker.getHost()), (Object)"Cannot change Worker host");
        Preconditions.checkArgument((boolean)newWorker.getIp().equals(oldWorker.getIp()), (Object)"Cannot change Worker ip");
        this.worker.set(newWorker);
    }

    public void setLastCompletedTaskTime(DateTime completedTaskTime) {
        this.lastCompletedTaskTime.set(completedTaskTime);
    }

    public void setBlacklistedUntil(DateTime blacklistedUntil) {
        this.blacklistedUntil.set(blacklistedUntil);
    }

    public ImmutableWorkerInfo toImmutable() {
        Map<String, TaskAnnouncement> tasks = this.getRunningTasks();
        return new ImmutableWorkerInfo(this.worker.get(), ZkWorker.getCurrCapacityUsed(tasks), this.getCurrParallelIndexCapacityUsed(tasks), ZkWorker.getAvailabilityGroups(tasks), tasks.keySet(), this.lastCompletedTaskTime.get(), this.blacklistedUntil.get());
    }

    @Override
    public void close() throws IOException {
        this.statusCache.close();
    }

    public int getContinuouslyFailedTasksCount() {
        return this.continuouslyFailedTasksCount.get();
    }

    public void resetContinuouslyFailedTasksCount() {
        this.continuouslyFailedTasksCount.set(0);
    }

    public void incrementContinuouslyFailedTasksCount() {
        this.continuouslyFailedTasksCount.incrementAndGet();
    }

    public String toString() {
        return "ZkWorker{worker=" + this.worker + ", lastCompletedTaskTime=" + this.lastCompletedTaskTime + ", blacklistedUntil=" + this.blacklistedUntil + '}';
    }
}

