/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunnerListener;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;

public interface TaskRunner {
    public List<Pair<Task, ListenableFuture<TaskStatus>>> restore();

    public void start();

    public void registerListener(TaskRunnerListener var1, Executor var2);

    public void unregisterListener(String var1);

    public ListenableFuture<TaskStatus> run(Task var1);

    public void shutdown(String var1, String var2);

    default public void shutdown(String taskid, String reasonFormat, Object ... args) {
        this.shutdown(taskid, StringUtils.format((String)reasonFormat, (Object[])args));
    }

    public void stop();

    public Collection<? extends TaskRunnerWorkItem> getRunningTasks();

    public Collection<? extends TaskRunnerWorkItem> getPendingTasks();

    public Collection<? extends TaskRunnerWorkItem> getKnownTasks();

    @Nullable
    default public RunnerTaskState getRunnerTaskState(String taskId) {
        return null;
    }

    default public TaskLocation getTaskLocation(String taskId) {
        return TaskLocation.unknown();
    }

    public Optional<ScalingStats> getScalingStats();

    public Map<String, Long> getTotalTaskSlotCount();

    public Map<String, Long> getIdleTaskSlotCount();

    public Map<String, Long> getUsedTaskSlotCount();

    public Map<String, Long> getLazyTaskSlotCount();

    public Map<String, Long> getBlacklistedTaskSlotCount();
}

