/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ConsoleLoggingEnforcementConfigurationFactory
extends ConfigurationFactory {
    public static final String[] SUFFIXES = new String[]{".xml", "*"};

    public String[] getSupportedTypes() {
        return SUFFIXES;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return new OverrideConfiguration(loggerContext, source);
    }

    static class OverrideConfiguration
    extends XmlConfiguration {
        public OverrideConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
            super(loggerContext, configSource);
        }

        protected void doConfigure() {
            super.doConfigure();
            Appender consoleAppender = this.findConsoleAppender();
            if (consoleAppender == null) {
                consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("_Injected_Console_Appender_")).setLayout((Layout)PatternLayout.newBuilder().withPattern("%d{ISO8601} %p [%t] %c - %m%n").build())).build();
            }
            ArrayList<Object> loggerConfigList = new ArrayList<Object>();
            loggerConfigList.add(this.getRootLogger());
            loggerConfigList.addAll(this.getLoggers().values());
            for (LoggerConfig loggerConfig : loggerConfigList) {
                this.applyConsoleAppender(loggerConfig, consoleAppender);
            }
        }

        @Nullable
        private Appender findConsoleAppender() {
            for (Map.Entry entry : this.getAppenders().entrySet()) {
                Appender appender = (Appender)entry.getValue();
                if (!(appender instanceof ConsoleAppender)) continue;
                return appender;
            }
            return null;
        }

        private void applyConsoleAppender(LoggerConfig logger, Appender consoleAppender) {
            if (logger.getAppenderRefs().size() == 1 && ((AppenderRef)logger.getAppenderRefs().get(0)).getRef().equals(consoleAppender.getName())) {
                return;
            }
            Level level = Level.INFO;
            Filter filter = null;
            if (!logger.getAppenderRefs().isEmpty()) {
                AppenderRef appenderRef = (AppenderRef)logger.getAppenderRefs().get(0);
                List<String> appendRefs = logger.getAppenderRefs().stream().map(AppenderRef::getRef).collect(Collectors.toList());
                appendRefs.forEach(arg_0 -> ((LoggerConfig)logger).removeAppender(arg_0));
                level = appenderRef.getLevel();
                filter = appenderRef.getFilter();
            }
            logger.addAppender(consoleAppender, level, filter);
        }
    }
}

