/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SegmentAllocators;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsMetadataReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.RangePartitionIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.partition.RangePartitionAnalysis;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.joda.time.Interval;

public class PartialRangeSegmentGenerateTask
extends PartialSegmentGenerateTask<GeneratedPartitionsMetadataReport> {
    public static final String TYPE = "partial_range_index_generate";
    private static final String PROP_SPEC = "spec";
    private static final boolean SKIP_NULL = true;
    private final String supervisorTaskId;
    private final String subtaskSpecId;
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final Map<Interval, PartitionBoundaries> intervalToPartitions;

    @JsonCreator
    public PartialRangeSegmentGenerateTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="intervalToPartitions") Map<Interval, PartitionBoundaries> intervalToPartitions) {
        super(PartialRangeSegmentGenerateTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema, context, new RangePartitionIndexTaskInputRowIteratorBuilder(PartialRangeSegmentGenerateTask.getPartitionDimensions(ingestionSchema), false));
        this.subtaskSpecId = subtaskSpecId;
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.intervalToPartitions = intervalToPartitions;
    }

    private static List<String> getPartitionDimensions(ParallelIndexIngestionSpec ingestionSpec) {
        PartitionsSpec partitionsSpec = ingestionSpec.getTuningConfig().getPartitionsSpec();
        Preconditions.checkArgument((boolean)(partitionsSpec instanceof DimensionRangePartitionsSpec), (String)"%s or %s partitionsSpec required", (Object[])new Object[]{"range", "single_dim"});
        DimensionRangePartitionsSpec multiDimPartitionsSpec = (DimensionRangePartitionsSpec)partitionsSpec;
        List partitionDimensions = multiDimPartitionsSpec.getPartitionDimensions();
        Preconditions.checkNotNull((Object)partitionDimensions, (Object)"partitionDimension required");
        return partitionDimensions;
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    public String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @Override
    @JsonProperty
    public String getSubtaskSpecId() {
        return this.subtaskSpecId;
    }

    @JsonProperty
    public Map<Interval, PartitionBoundaries> getIntervalToPartitions() {
        return this.intervalToPartitions;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws IOException {
        return this.tryTimeChunkLock(new SurrogateTaskActionClient(this.supervisorTaskId, taskActionClient), this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
    }

    @Override
    SegmentAllocatorForBatch createSegmentAllocator(TaskToolbox toolbox, ParallelIndexSupervisorTaskClient taskClient) throws IOException {
        RangePartitionAnalysis partitionAnalysis = new RangePartitionAnalysis((DimensionRangePartitionsSpec)this.ingestionSchema.getTuningConfig().getPartitionsSpec());
        this.intervalToPartitions.forEach(partitionAnalysis::updateBucket);
        return SegmentAllocators.forNonLinearPartitioning(toolbox, this.getDataSource(), this.getSubtaskSpecId(), this.ingestionSchema.getDataSchema().getGranularitySpec(), new SupervisorTaskAccess(this.supervisorTaskId, taskClient), partitionAnalysis);
    }

    @Override
    GeneratedPartitionsMetadataReport createGeneratedPartitionsReport(TaskToolbox toolbox, List<DataSegment> segments, Map<String, TaskReport> taskReport) {
        List<PartitionStat> partitionStats = segments.stream().map(segment -> toolbox.getIntermediaryDataManager().generatePartitionStat(toolbox, (DataSegment)segment)).collect(Collectors.toList());
        return new GeneratedPartitionsMetadataReport(this.getId(), partitionStats, taskReport);
    }
}

