/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.CompactionIOConfig;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.segment.indexing.BatchIOConfig;
import org.joda.time.Interval;

public abstract class AbstractTask
implements Task {
    private final IngestionMode ingestionMode;
    @JsonIgnore
    private final String id;
    @JsonIgnore
    private final String groupId;
    @JsonIgnore
    private final TaskResource taskResource;
    @JsonIgnore
    private final String dataSource;
    private final Map<String, Object> context;
    private final ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();

    protected AbstractTask(String id, String dataSource, Map<String, Object> context, IngestionMode ingestionMode) {
        this(id, null, null, dataSource, context, ingestionMode);
    }

    protected AbstractTask(String id, String dataSource, Map<String, Object> context) {
        this(id, null, null, dataSource, context, IngestionMode.NONE);
    }

    protected AbstractTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, String dataSource, @Nullable Map<String, Object> context, @Nonnull IngestionMode ingestionMode) {
        this.id = IdUtils.validateId((String)"task ID", (String)id);
        this.groupId = groupId == null ? id : groupId;
        this.taskResource = taskResource == null ? new TaskResource(id, 1) : taskResource;
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.context = context == null ? new HashMap<String, Object>() : new HashMap<String, Object>(context);
        this.ingestionMode = ingestionMode;
        IndexTaskUtils.setTaskDimensions(this.metricBuilder, this);
    }

    protected AbstractTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, String dataSource, @Nullable Map<String, Object> context) {
        this(id, groupId, taskResource, dataSource, context, IngestionMode.NONE);
    }

    public static String getOrMakeId(@Nullable String id, String typeName, String dataSource) {
        return AbstractTask.getOrMakeId(id, typeName, dataSource, null);
    }

    static String getOrMakeId(@Nullable String id, String typeName, String dataSource, @Nullable Interval interval) {
        if (id != null) {
            return id;
        }
        return IdUtils.newTaskId((String)typeName, (String)dataSource, (Interval)interval);
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="resource")
    public TaskResource getTaskResource() {
        return this.taskResource;
    }

    @Override
    public String getNodeType() {
        return null;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return null;
    }

    @Override
    public boolean supportsQueries() {
        return false;
    }

    @Override
    public String getClasspathPrefix() {
        return null;
    }

    @Override
    public boolean canRestore() {
        return false;
    }

    public String toString() {
        return "AbstractTask{id='" + this.id + '\'' + ", groupId='" + this.groupId + '\'' + ", taskResource=" + this.taskResource + ", dataSource='" + this.dataSource + '\'' + ", context=" + this.context + '}';
    }

    public TaskStatus success() {
        return TaskStatus.success((String)this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTask that = (AbstractTask)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.dataSource.equals(that.dataSource)) {
            return false;
        }
        return this.context.equals(that.context);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.groupId, this.dataSource, this.context});
    }

    public static List<TaskLock> getTaskLocks(TaskActionClient client) throws IOException {
        return client.submit(new LockListAction());
    }

    @Override
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    protected boolean isUseMaxMemoryEstimates() {
        return this.getContextValue("useMaxMemoryEstimates", true);
    }

    protected ServiceMetricEvent.Builder getMetricBuilder() {
        return this.metricBuilder;
    }

    public IngestionMode getIngestionMode() {
        return this.ingestionMode;
    }

    protected static IngestionMode computeCompactionIngestionMode(@Nullable CompactionIOConfig ioConfig) {
        boolean isAppendToExisting = false;
        boolean isDropExisting = ioConfig == null ? false : ioConfig.isDropExisting();
        return AbstractTask.computeIngestionMode(false, isDropExisting);
    }

    protected static IngestionMode computeBatchIngestionMode(@Nullable BatchIOConfig ioConfig) {
        boolean isAppendToExisting = ioConfig == null ? false : ioConfig.isAppendToExisting();
        boolean isDropExisting = ioConfig == null ? false : ioConfig.isDropExisting();
        return AbstractTask.computeIngestionMode(isAppendToExisting, isDropExisting);
    }

    private static IngestionMode computeIngestionMode(boolean isAppendToExisting, boolean isDropExisting) {
        if (!isAppendToExisting && isDropExisting) {
            return IngestionMode.REPLACE;
        }
        if (isAppendToExisting && !isDropExisting) {
            return IngestionMode.APPEND;
        }
        if (!isAppendToExisting) {
            return IngestionMode.REPLACE_LEGACY;
        }
        throw new IAE("Cannot simultaneously replace and append to existing segments. Either dropExisting or appendToExisting should be set to false", new Object[0]);
    }

    public void emitMetric(ServiceEmitter emitter, String metric, Number value) {
        if (emitter == null || metric == null || value == null) {
            return;
        }
        emitter.emit(this.getMetricBuilder().build(metric, value));
    }

    public static enum IngestionMode {
        REPLACE,
        APPEND,
        REPLACE_LEGACY,
        HADOOP,
        NONE;


        @JsonCreator
        public static IngestionMode fromString(String name) {
            if (name == null) {
                return null;
            }
            return IngestionMode.valueOf(StringUtils.toUpperCase((String)name));
        }
    }
}

