/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.joda.time.Interval;

public class SegmentLockReleaseAction
implements TaskAction<Void> {
    private final Interval interval;
    private final int partitionId;

    @JsonCreator
    public SegmentLockReleaseAction(@JsonProperty Interval interval, @JsonProperty int partitionId) {
        this.interval = interval;
        this.partitionId = partitionId;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) {
        toolbox.getTaskLockbox().unlock(task, this.interval, this.partitionId);
        return null;
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    @Override
    public String toString() {
        return "SegmentLockReleaseAction{interval=" + this.interval + ", partitionId=" + this.partitionId + '}';
    }
}

