/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionHolder;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class RemoteTaskActionClient
implements TaskActionClient {
    private final Task task;
    private final ObjectMapper jsonMapper;
    private final ServiceClient client;
    private static final Logger log = new Logger(RemoteTaskActionClient.class);

    public RemoteTaskActionClient(Task task, ServiceClient client, ObjectMapper jsonMapper) {
        this.task = task;
        this.client = client;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) throws IOException {
        log.debug("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        try {
            Map response = (Map)this.jsonMapper.readValue(((BytesFullResponseHolder)this.client.request(new RequestBuilder(HttpMethod.POST, "/druid/indexer/v1/action").jsonContent(this.jsonMapper, (Object)new TaskActionHolder(this.task, taskAction)), (HttpResponseHandler)new BytesFullResponseHandler())).getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            return (RetType)this.jsonMapper.convertValue(response.get("result"), taskAction.getReturnTypeReference());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpResponseException) {
                StringFullResponseHolder fullResponseHolder = ((HttpResponseException)e.getCause()).getResponse();
                throw new IOE("Error with status[%s] and message[%s]. Check overlord logs for details.", new Object[]{fullResponseHolder.getStatus(), fullResponseHolder.getContent()});
            }
            throw new IOException(e.getCause());
        }
    }
}

