/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.seekablestream.SeekableStreamDataSourceMetadata;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;

public class CheckPointDataSourceMetadataAction
implements TaskAction<Boolean> {
    private final String supervisorId;
    private final int taskGroupId;
    private final SeekableStreamDataSourceMetadata checkpointMetadata;

    public CheckPointDataSourceMetadataAction(@JsonProperty(value="supervisorId") String supervisorId, @JsonProperty(value="taskGroupId") Integer taskGroupId, @JsonProperty(value="previousCheckPoint") @Nullable @Deprecated SeekableStreamDataSourceMetadata previousCheckPoint, @JsonProperty(value="checkpointMetadata") @Nullable SeekableStreamDataSourceMetadata checkpointMetadata) {
        this.supervisorId = (String)Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId");
        this.taskGroupId = (Integer)Preconditions.checkNotNull((Object)taskGroupId, (Object)"taskGroupId");
        this.checkpointMetadata = checkpointMetadata == null ? previousCheckPoint : checkpointMetadata;
        Preconditions.checkNotNull((Object)this.checkpointMetadata, (Object)"checkpointMetadata");
        Preconditions.checkArgument((boolean)(this.checkpointMetadata.getSeekableStreamSequenceNumbers() instanceof SeekableStreamStartSequenceNumbers), (Object)"checkpointMetadata must be SeekableStreamStartSequenceNumbers");
    }

    @JsonProperty
    public String getSupervisorId() {
        return this.supervisorId;
    }

    @Nullable
    @JsonProperty
    public Integer getTaskGroupId() {
        return this.taskGroupId;
    }

    @JsonProperty
    private SeekableStreamDataSourceMetadata getPreviousCheckPoint() {
        return this.checkpointMetadata;
    }

    @JsonProperty
    private SeekableStreamDataSourceMetadata getCurrentCheckPoint() {
        return this.checkpointMetadata;
    }

    @JsonProperty(value="sequenceName")
    private String getBaseSequenceName() {
        return "dummy";
    }

    @JsonProperty
    public SeekableStreamDataSourceMetadata getCheckpointMetadata() {
        return this.checkpointMetadata;
    }

    @Override
    public TypeReference<Boolean> getReturnTypeReference() {
        return new TypeReference<Boolean>(){};
    }

    @Override
    public Boolean perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getSupervisorManager().checkPointDataSourceMetadata(this.supervisorId, this.taskGroupId, this.checkpointMetadata);
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "CheckPointDataSourceMetadataAction{supervisorId='" + this.supervisorId + '\'' + ", taskGroupId='" + this.taskGroupId + '\'' + ", checkpointMetadata=" + this.checkpointMetadata + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckPointDataSourceMetadataAction that = (CheckPointDataSourceMetadataAction)o;
        if (!this.supervisorId.equals(that.supervisorId)) {
            return false;
        }
        if (this.taskGroupId != that.taskGroupId) {
            return false;
        }
        return Objects.equals(this.checkpointMetadata, that.checkpointMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.supervisorId, this.taskGroupId, this.checkpointMetadata);
    }
}

