/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsJsonConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsJsonConsumer.class);
    private String jwsSignedDocument;
    private String jwsPayload;
    private List<JwsJsonSignatureEntry> signatures = new LinkedList<JwsJsonSignatureEntry>();

    public JwsJsonConsumer(String jwsSignedDocument) {
        this(jwsSignedDocument, null);
    }

    public JwsJsonConsumer(String jwsSignedDocument, String detachedPayload) {
        this.jwsSignedDocument = jwsSignedDocument;
        this.prepare(detachedPayload);
    }

    private void prepare(String detachedPayload) {
        JsonMapObject jsonObject = new JsonMapObject();
        new JsonMapObjectReaderWriter().fromJson(jsonObject, this.jwsSignedDocument);
        Map jsonObjectMap = jsonObject.asMap();
        this.jwsPayload = (String)jsonObjectMap.get("payload");
        if (this.jwsPayload == null) {
            this.jwsPayload = detachedPayload;
        } else if (detachedPayload != null) {
            LOG.warning("JSON JWS includes a payload expected to be detached");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        if (this.jwsPayload == null) {
            LOG.warning("JSON JWS has no payload");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        List signatureArray = CastUtils.cast((List)((List)jsonObjectMap.get("signatures")));
        if (signatureArray != null) {
            if (jsonObjectMap.containsKey("signature")) {
                LOG.warning("JSON JWS has a flattened 'signature' element and a 'signatures' object");
                throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
            }
            for (Map signatureEntry : signatureArray) {
                this.signatures.add(this.getSignatureObject(signatureEntry));
            }
        } else {
            this.signatures.add(this.getSignatureObject(jsonObjectMap));
        }
        if (this.signatures.isEmpty()) {
            LOG.warning("JSON JWS has no signatures");
            throw new JwsException(JwsException.Error.INVALID_JSON_JWS);
        }
        this.validateB64Status();
    }

    private Boolean validateB64Status() {
        return JwsJsonProducer.validateB64Status(this.signatures);
    }

    protected JwsJsonSignatureEntry getSignatureObject(Map<String, Object> signatureEntry) {
        String protectedHeader = (String)signatureEntry.get("protected");
        Map header = CastUtils.cast((Map)((Map)signatureEntry.get("header")));
        String signature = (String)signatureEntry.get("signature");
        return new JwsJsonSignatureEntry(this.jwsPayload, protectedHeader, signature, header != null ? new JwsHeaders(header) : null);
    }

    public String getSignedDocument() {
        return this.jwsSignedDocument;
    }

    public String getJwsPayload() {
        return this.jwsPayload;
    }

    public String getDecodedJwsPayload() {
        if (this.validateB64Status().booleanValue()) {
            return JoseUtils.decodeToString(this.jwsPayload);
        }
        return this.jwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8((String)this.getDecodedJwsPayload());
    }

    public List<JwsJsonSignatureEntry> getSignatureEntries() {
        return Collections.unmodifiableList(this.signatures);
    }

    public Map<SignatureAlgorithm, List<JwsJsonSignatureEntry>> getSignatureEntryMap() {
        return JwsUtils.getJwsJsonSignatureMap(this.signatures);
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        return this.verifySignatureWith(validator, null);
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator, Map<String, Object> entryProps) {
        List<JwsJsonSignatureEntry> theSignatureEntries = this.getSignatureEntryMap().get((Object)validator.getAlgorithm());
        if (theSignatureEntries != null) {
            for (JwsJsonSignatureEntry signatureEntry : theSignatureEntries) {
                if (entryProps != null && !signatureEntry.getUnionHeader().asMap().entrySet().containsAll(entryProps.entrySet()) || !signatureEntry.verifySignatureWith(validator)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifySignatureWith(PublicKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(key, algo, null);
    }

    public boolean verifySignatureWith(PublicKey key, SignatureAlgorithm algo, Map<String, Object> entryProps) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(key, algo), entryProps);
    }

    public boolean verifySignatureWith(byte[] key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(key, algo, null);
    }

    public boolean verifySignatureWith(byte[] key, SignatureAlgorithm algo, Map<String, Object> entryProps) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo), entryProps);
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(JsonWebKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(key, algo, null);
    }

    public boolean verifySignatureWith(JsonWebKey key, SignatureAlgorithm algo, Map<String, Object> entryProps) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key, algo), entryProps);
    }

    public boolean verifySignatureWith(List<JwsSignatureVerifier> validators) {
        return this.verifySignatureWith(validators, null);
    }

    public boolean verifySignatureWith(List<JwsSignatureVerifier> validators, Map<String, Object> entryProps) {
        try {
            this.verifyAndGetNonValidated(validators, entryProps);
        }
        catch (JwsException ex) {
            LOG.warning("One of JSON JWS signatures is invalid");
            return false;
        }
        return true;
    }

    public List<JwsJsonSignatureEntry> verifyAndGetNonValidated(List<JwsSignatureVerifier> validators) {
        return this.verifyAndGetNonValidated(validators, null);
    }

    public List<JwsJsonSignatureEntry> verifyAndGetNonValidated(List<JwsSignatureVerifier> validators, Map<String, Object> entryProps) {
        LinkedList<JwsJsonSignatureEntry> validatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        block0: for (JwsSignatureVerifier validator : validators) {
            List<JwsJsonSignatureEntry> theSignatureEntries = this.getSignatureEntryMap().get((Object)validator.getAlgorithm());
            if (theSignatureEntries == null) continue;
            for (JwsJsonSignatureEntry sigEntry : theSignatureEntries) {
                if (entryProps != null && !sigEntry.getUnionHeader().asMap().entrySet().containsAll(entryProps.entrySet()) || !sigEntry.verifySignatureWith(validator)) continue;
                validatedSignatures.add(sigEntry);
                continue block0;
            }
        }
        if (validatedSignatures.isEmpty()) {
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        LinkedList<JwsJsonSignatureEntry> nonValidatedSignatures = new LinkedList<JwsJsonSignatureEntry>();
        for (JwsJsonSignatureEntry sigEntry : this.signatures) {
            if (validatedSignatures.contains(sigEntry)) continue;
            nonValidatedSignatures.add(sigEntry);
        }
        return nonValidatedSignatures;
    }

    public String verifyAndProduce(List<JwsSignatureVerifier> validators) {
        return this.verifyAndProduce(validators, null);
    }

    public String verifyAndProduce(List<JwsSignatureVerifier> validators, Map<String, Object> entryProps) {
        List<JwsJsonSignatureEntry> nonValidated = this.verifyAndGetNonValidated(validators, entryProps);
        if (!nonValidated.isEmpty()) {
            JwsJsonProducer producer = new JwsJsonProducer(this.getDecodedJwsPayload());
            producer.getSignatureEntries().addAll(nonValidated);
            return producer.getJwsJsonSignedDocument();
        }
        return null;
    }
}

