/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs2.provider.sftp.UserIsOwnerPosixPermissions;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.PosixPermissions;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject<SftpFileSystem> {
    private static final long MOD_TIME_FACTOR = 1000L;
    private SftpATTRS attrs;
    private final String relPath;
    private boolean inRefresh;

    protected SftpFileObject(AbstractFileName name, SftpFileSystem fileSystem) throws FileSystemException {
        super(name, fileSystem);
        this.relPath = UriParser.decode(fileSystem.getRootName().getRelativeName(name));
    }

    @Override
    protected void doDetach() throws Exception {
        this.attrs = null;
    }

    @Override
    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws IOException {
        block8: {
            ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
            try {
                this.setStat(channel.stat(this.relPath));
            }
            catch (SftpException e) {
                try {
                    if (e.id != 2) {
                        channel.disconnect();
                        channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
                        this.setStat(channel.stat(this.relPath));
                        break block8;
                    }
                    this.attrs = null;
                }
                catch (SftpException innerEx) {
                    this.attrs = null;
                }
            }
            finally {
                ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
            }
        }
    }

    private void setStat(SftpATTRS attrs) {
        this.attrs = attrs;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            channel.mkdir(this.relPath);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        int newMTime = (int)(modtime / 1000L);
        this.attrs.setACMODTIME(this.attrs.getATime(), newMTime);
        this.flushStat();
        return true;
    }

    private void flushStat() throws IOException, SftpException {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            channel.setStat(this.relPath, this.attrs);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
        }
    }

    @Override
    protected void doDelete() throws Exception {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            if (this.isFile()) {
                channel.rm(this.relPath);
            } else {
                channel.rmdir(this.relPath);
            }
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject newFile) throws Exception {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            SftpFileObject newSftpFileObject = (SftpFileObject)FileObjectUtils.getAbstractFileObject(newFile);
            channel.rename(this.relPath, newSftpFileObject.relPath);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
        }
    }

    protected PosixPermissions getPermissions(boolean checkIds) throws Exception {
        this.statSelf();
        boolean isInGroup = false;
        if (checkIds) {
            if (((SftpFileSystem)this.getAbstractFileSystem()).isExecDisabled()) {
                return new UserIsOwnerPosixPermissions(this.attrs.getPermissions());
            }
            for (int groupId : ((SftpFileSystem)this.getAbstractFileSystem()).getGroupsIds()) {
                if (groupId != this.attrs.getGId()) continue;
                isInGroup = true;
                break;
            }
        }
        boolean isOwner = checkIds && this.attrs.getUId() == ((SftpFileSystem)this.getAbstractFileSystem()).getUId();
        return new PosixPermissions(this.attrs.getPermissions(), isOwner, isInGroup);
    }

    @Override
    protected boolean doIsReadable() throws Exception {
        return this.getPermissions(true).isReadable();
    }

    @Override
    protected boolean doSetReadable(boolean readable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeReadable(readable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws Exception {
        return this.getPermissions(true).isWritable();
    }

    @Override
    protected boolean doSetWritable(boolean writable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeWritable(writable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    @Override
    protected boolean doIsExecutable() throws Exception {
        return this.getPermissions(true).isExecutable();
    }

    @Override
    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeExecutable(executable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.isFile()) {
            return null;
        }
        Vector vector = null;
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            vector = channel.ls(this.relPath);
        }
        catch (SftpException e) {
            String workingDirectory = null;
            try {
                if (this.relPath != null) {
                    workingDirectory = channel.pwd();
                    channel.cd(this.relPath);
                }
            }
            catch (SftpException ex) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            SftpException lsEx = null;
            try {
                vector = channel.ls(".");
            }
            catch (SftpException ex) {
                lsEx = ex;
            }
            finally {
                try {
                    if (this.relPath != null) {
                        channel.cd(workingDirectory);
                    }
                }
                catch (SftpException xe) {
                    throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", (Object)workingDirectory, (Throwable)lsEx);
                }
            }
            if (lsEx != null) {
                throw lsEx;
            }
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
        }
        FileSystemException.requireNonNull(vector, "vfs.provider.sftp/list-children.error");
        ArrayList<FileObject> children = new ArrayList<FileObject>();
        for (ChannelSftp.LsEntry stat : vector) {
            String name = stat.getFilename();
            if (VFS.isUriStyle() && stat.getAttrs().isDir() && name.charAt(name.length() - 1) != '/') {
                name = name + "/";
            }
            if (name.equals(".") || name.equals("..") || name.equals("./") || name.equals("../")) continue;
            FileObject fo = this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(name), NameScope.CHILD));
            ((SftpFileObject)FileObjectUtils.getAbstractFileObject(fo)).setStat(stat.getAttrs());
            children.add(fo);
        }
        return children.toArray(FileObject.EMPTY_ARRAY);
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return null;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SftpRandomAccessContent(this, mode);
    }

    InputStream getInputStream(long filePointer) throws IOException {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        try {
            return new SftpInputStream(channel, channel.get(this.getName().getPathDecoded(), null, filePointer));
        }
        catch (SftpException e) {
            ((SftpFileSystem)this.getAbstractFileSystem()).putChannel(channel);
            throw new FileSystemException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        SftpFileSystem sftpFileSystem = (SftpFileSystem)this.getAbstractFileSystem();
        synchronized (sftpFileSystem) {
            InputStream inputStream;
            ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
            try {
                if (!this.getType().hasContent()) {
                    throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
                }
                inputStream = channel.get(this.relPath);
            }
            catch (SftpException e) {
                if (e.id == 2) {
                    throw new FileNotFoundException(this.getName());
                }
                throw new FileSystemException(e);
            }
            return new SftpInputStream(channel, inputStream, bufferSize);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        ChannelSftp channel = ((SftpFileSystem)this.getAbstractFileSystem()).getChannel();
        return new SftpOutputStream(channel, channel.put(this.relPath, bAppend ? 2 : 0));
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channel, OutputStream out) {
            super(out);
            this.channel = channel;
        }

        @Override
        protected void onClose() throws IOException {
            ((SftpFileSystem)SftpFileObject.this.getAbstractFileSystem()).putChannel(this.channel);
        }
    }

    private class SftpInputStream
    extends MonitorInputStream {
        private final ChannelSftp channel;

        public SftpInputStream(ChannelSftp channel, InputStream in) {
            super(in);
            this.channel = channel;
        }

        public SftpInputStream(ChannelSftp channel, InputStream in, int bufferSize) {
            super(in, bufferSize);
            this.channel = channel;
        }

        @Override
        protected void onClose() throws IOException {
            ((SftpFileSystem)SftpFileObject.this.getAbstractFileSystem()).putChannel(this.channel);
        }
    }
}

