/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public final class VFS {
    private static FileSystemManager instance;
    private static Boolean uriStyle;

    public static synchronized void close() {
        if (instance != null) {
            instance.close();
        }
    }

    private static FileSystemManager createFileSystemManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> clazz = Class.forName(managerClassName);
            FileSystemManager manager = (FileSystemManager)clazz.newInstance();
            try {
                clazz.getMethod("init", null).invoke((Object)manager, (Object[])null);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return manager;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.reset();
        }
        return instance;
    }

    public static boolean isUriStyle() {
        if (uriStyle == null) {
            uriStyle = Boolean.FALSE;
        }
        return uriStyle;
    }

    public static synchronized FileSystemManager reset() throws FileSystemException {
        VFS.close();
        instance = VFS.createFileSystemManager("org.apache.commons.vfs2.impl.StandardFileSystemManager");
        return instance;
    }

    public static synchronized void setManager(FileSystemManager manager) {
        instance = manager;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (VFS.uriStyle != null && VFS.uriStyle != uriStyle) {
            throw new IllegalStateException("VFS.uriStyle was already set differently.");
        }
        VFS.uriStyle = uriStyle;
    }

    private VFS() {
    }
}

