/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.URISupport;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    private static final String INTEGRATION_VERSION = "camel.apache.org/v1";
    private static final String BINDING_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1";
    private static final String KNATIVE_VERSION = "messaging.knative.dev/v1";

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    @Override
    protected RouteBuilder builder(final Node root, final Resource resource) {
        final HashSet indexes = new HashSet();
        return new RouteConfigurationBuilder(){

            public void configure() throws Exception {
                YamlDeserializationContext ctx = YamlRoutesBuilderLoader.this.getDeserializationContext();
                ctx.setResource(resource);
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx);
                if (target == null) {
                    return;
                }
                if (target instanceof Node) {
                    SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                    for (Node node : seq.getValue()) {
                        Object item;
                        boolean accepted;
                        int idx = -1;
                        if (node.getStartMark().isPresent()) {
                            idx = ((Mark)node.getStartMark().get()).getIndex();
                        }
                        if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfigure(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                        indexes.add(idx);
                    }
                } else {
                    this.doConfigure(target);
                }
            }

            private boolean doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route(route);
                    return true;
                }
                if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                    return true;
                }
                if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                    return true;
                }
                if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRouteCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                    return true;
                }
                if (item instanceof ErrorHandlerBuilder) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerBuilder)item);
                    return true;
                }
                if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteTemplateCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                    return true;
                }
                if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext((Object)this.getRestCollection(), (CamelContext)this.getCamelContext());
                    this.getRestCollection().rest(definition);
                    return true;
                }
                if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    return true;
                }
                return false;
            }

            public void configuration() throws Exception {
                YamlDeserializationContext ctx = YamlRoutesBuilderLoader.this.getDeserializationContext();
                ctx.setResource(resource);
                YamlDeserializerSupport.setDeserializationContext((Node)root, (YamlDeserializationContext)ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx);
                if (target == null) {
                    return;
                }
                if (target instanceof Node) {
                    SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)((Node)target));
                    for (Node node : seq.getValue()) {
                        Object item;
                        boolean accepted;
                        int idx = -1;
                        if (node.getStartMark().isPresent()) {
                            idx = ((Mark)node.getStartMark().get()).getIndex();
                        }
                        if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfiguration(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                        indexes.add(idx);
                    }
                } else {
                    this.doConfiguration(target);
                }
            }

            private boolean doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext((Object)this.getRouteConfigurationCollection(), (CamelContext)this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                    return true;
                }
                return false;
            }
        };
    }

    private Object preConfigureNode(Node root, YamlDeserializationContext ctx) throws Exception {
        Object target = root;
        if (Objects.equals(root.getNodeType(), NodeType.MAPPING)) {
            boolean binding;
            MappingNode mn = YamlDeserializerSupport.asMappingNode((Node)root);
            boolean integration = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Integration");
            boolean bl = binding = this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KameletBinding");
            if (integration) {
                target = this.preConfigureIntegration(root, ctx, target);
            } else if (binding) {
                target = this.preConfigureKameletBinding(root, ctx, target);
            }
        }
        return target;
    }

    private Object preConfigureIntegration(Node root, YamlDeserializationContext ctx, Object target) {
        Node routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flows");
        if (routes == null) {
            routes = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/flow");
        }
        if (routes != null) {
            target = routes;
        }
        return target;
    }

    private Object preConfigureKameletBinding(Node root, YamlDeserializationContext ctx, Object target) throws Exception {
        RouteDefinition route = new RouteDefinition();
        String routeId = YamlDeserializerSupport.asText((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/metadata/name"));
        if (routeId != null) {
            route.routeId(routeId);
        }
        MappingNode source = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/source"));
        MappingNode sink = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/sink"));
        if (source != null && sink != null) {
            MappingNode errorHandler;
            Node steps;
            int line = -1;
            if (source.getStartMark().isPresent()) {
                line = ((Mark)source.getStartMark().get()).getLine();
            }
            String uri = this.extractCamelEndpointUri(source);
            route.from(uri);
            if (line != -1) {
                route.getInput().setLineNumber(line);
                if (ctx != null) {
                    route.getInput().setLocation(ctx.getResource().getLocation());
                }
            }
            if ((steps = YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/steps")) != null) {
                SequenceNode sn = YamlDeserializerSupport.asSequenceNode((Node)steps);
                for (Node node : sn.getValue()) {
                    ToDefinition out;
                    boolean kamelet;
                    MappingNode step = YamlDeserializerSupport.asMappingNode((Node)node);
                    uri = this.extractCamelEndpointUri(step);
                    if (uri == null) continue;
                    line = -1;
                    if (node.getStartMark().isPresent()) {
                        line = ((Mark)node.getStartMark().get()).getLine();
                    }
                    if (kamelet = uri.startsWith("kamelet:")) {
                        uri = uri.substring(8);
                        out = new KameletDefinition(uri);
                    } else {
                        out = new ToDefinition(uri);
                    }
                    route.addOutput((ProcessorDefinition)out);
                    if (line == -1) continue;
                    out.setLineNumber(line);
                    if (ctx == null) continue;
                    out.setLocation(ctx.getResource().getLocation());
                }
            }
            line = -1;
            if (sink.getStartMark().isPresent()) {
                line = ((Mark)sink.getStartMark().get()).getLine();
            }
            uri = this.extractCamelEndpointUri(sink);
            ToDefinition to = new ToDefinition(uri);
            route.addOutput((ProcessorDefinition)to);
            if (line != -1) {
                to.setLineNumber(line);
                if (ctx != null) {
                    to.setLocation(ctx.getResource().getLocation());
                }
            }
            if ((errorHandler = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)root, (String)"/spec/errorHandler"))) != null) {
                NodeTuple nt = (NodeTuple)errorHandler.getValue().get(0);
                String ehName = YamlDeserializerSupport.asText((Node)nt.getKeyNode());
                DefaultErrorHandlerBuilder ehb = null;
                if ("sink".equals(ehName)) {
                    DeadLetterChannelBuilder dlch = new DeadLetterChannelBuilder();
                    MappingNode endpoint = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/endpoint"));
                    String dlq = this.extractCamelEndpointUri(endpoint);
                    dlch.setDeadLetterUri(dlq);
                    ehb = dlch;
                } else if ("log".equals(ehName)) {
                    ehb = new DefaultErrorHandlerBuilder();
                } else if ("none".equals(ehName)) {
                    route.errorHandler((ErrorHandlerFactory)new NoErrorHandlerBuilder());
                }
                if (ehb != null) {
                    MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)nt.getValueNode(), (String)"/parameters"));
                    Map params = YamlDeserializerSupport.asMap((Node)prop);
                    if (params != null) {
                        PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget((Object)ehb).withProperties(params).bind();
                    }
                    route.errorHandler((ErrorHandlerFactory)ehb);
                }
            }
            target = route;
        }
        return target;
    }

    private String extractCamelEndpointUri(MappingNode node) throws Exception {
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt((Node)node, (String)"/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode((Node)ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "kind", "KafkaTopic");
        boolean knative = !kamelet && !strimzi && mn != null && this.anyTupleMatches((List<NodeTuple>)mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_VERSION));
        Object uri = kamelet || strimzi || knative ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri");
        MappingNode prop = YamlDeserializerSupport.asMappingNode((Node)YamlDeserializerSupport.nodeAt((Node)node, (String)"/properties"));
        Map params = YamlDeserializerSupport.asMap((Node)prop);
        if (params != null && !params.isEmpty()) {
            String query = URISupport.createQueryString((Map)params);
            uri = (String)uri + "?" + query;
        }
        if (kamelet) {
            return "kamelet:" + (String)uri;
        }
        if (strimzi) {
            return "kafka:" + (String)uri;
        }
        if (knative) {
            return "knative:channel/" + (String)uri;
        }
        return uri;
    }
}

