/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Visitor;

public class UnaryExpression
extends Expression {
    public final Expression expression;

    UnaryExpression(ExpressionType nodeType, Type type, Expression expression) {
        super(nodeType, type);
        assert (expression != null) : "expression should not be null";
        this.expression = expression;
    }

    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression expression = this.expression.accept(visitor);
        return visitor.visit(this, expression);
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        switch (this.nodeType) {
            case Convert: {
                if (!writer.requireParentheses(this, lprec, rprec)) {
                    writer.append("(").append(this.type).append(") ");
                    this.expression.accept(writer, this.nodeType.rprec, rprec);
                }
                return;
            }
        }
        if (this.nodeType.postfix) {
            this.expression.accept(writer, lprec, this.nodeType.rprec);
            writer.append(this.nodeType.op);
        } else {
            writer.append(this.nodeType.op);
            this.expression.accept(writer, this.nodeType.lprec, rprec);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.expression.hashCode();
        return result;
    }
}

