/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String classClass = "class";
    public final String name;
    public final List<MemberDeclaration> memberDeclarations;
    public final Type extended;
    public final List<Type> implemented;

    public ClassDeclaration(int modifier, String name, Type extended, List<Type> implemented, List<MemberDeclaration> memberDeclarations) {
        assert (name != null) : "name should not be null";
        this.modifier = modifier;
        this.name = name;
        this.memberDeclarations = memberDeclarations;
        this.extended = extended;
        this.implemented = implemented;
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append("class").append(' ').append(this.name);
        if (this.extended != null) {
            writer.append(" extends ").append(this.extended);
        }
        if (!this.implemented.isEmpty()) {
            writer.list(" implements ", ", ", "", this.implemented);
        }
        writer.list(" {\n", "", "}", this.memberDeclarations);
        writer.newlineAndIndent();
    }

    @Override
    public ClassDeclaration accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        List<MemberDeclaration> members1 = Expressions.acceptMemberDeclarations(this.memberDeclarations, visitor);
        return visitor.visit(this, members1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDeclaration that = (ClassDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (!"class".equals(that.classClass)) {
            return false;
        }
        if (this.extended != null ? !this.extended.equals(that.extended) : that.extended != null) {
            return false;
        }
        if (this.implemented != null ? !this.implemented.equals(that.implemented) : that.implemented != null) {
            return false;
        }
        if (this.memberDeclarations != null ? !this.memberDeclarations.equals(that.memberDeclarations) : that.memberDeclarations != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.modifier;
        result = 31 * result + "class".hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.memberDeclarations != null ? this.memberDeclarations.hashCode() : 0);
        result = 31 * result + (this.extended != null ? this.extended.hashCode() : 0);
        result = 31 * result + (this.implemented != null ? this.implemented.hashCode() : 0);
        return result;
    }
}

